/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.evento.cancelamento.NFInfoCancelamento;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.IntegerValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class NFInfoEventoCancelamento
extends DFBase {
    private static final long serialVersionUID = 1491402822907097339L;
    @Attribute(name="Id")
    private String id;
    @Element(name="cOrgao")
    private DFUnidadeFederativa orgao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="chNFe")
    private String chave;
    @Element(name="dhEvento")
    private ZonedDateTime dataHoraEvento;
    @Element(name="tpEvento")
    private String codigoEvento;
    @Element(name="nSeqEvento")
    private Integer numeroSequencialEvento;
    @Element(name="verEvento")
    private String versaoEvento;
    @Element(name="detEvento")
    private NFInfoCancelamento cancelamento;

    public void setOrgao(DFUnidadeFederativa dFUnidadeFederativa) {
        this.orgao = dFUnidadeFederativa;
    }

    public void setVersaoEvento(BigDecimal bigDecimal) {
        this.versaoEvento = BigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao do Evento");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        StringValidador.exatamente54(string, "Info Evento Cancelamento ID");
        this.id = string;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("CPF ja foi setado");
        }
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("CNPJ ja foi setado");
        }
        StringValidador.cpf(string);
        this.cpf = string;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        StringValidador.exatamente44N(string, "Info Evento Cancelamento Chave");
        this.chave = string;
    }

    public ZonedDateTime getDataHoraEvento() {
        return this.dataHoraEvento;
    }

    public void setDataHoraEvento(ZonedDateTime zonedDateTime) {
        this.dataHoraEvento = zonedDateTime;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String string) {
        StringValidador.exatamente6N(string, "Info Evento Cancelamento Codigo");
        this.codigoEvento = string;
    }

    public int getNumeroSequencialEvento() {
        return this.numeroSequencialEvento;
    }

    public void setNumeroSequencialEvento(int n) {
        IntegerValidador.tamanho1a2(n, "Numero Sequencial Evento");
        this.numeroSequencialEvento = n;
    }

    public String getVersaoEvento() {
        return this.versaoEvento;
    }

    public NFInfoCancelamento getCancelamento() {
        return this.cancelamento;
    }

    public void setCancelamento(NFInfoCancelamento nFInfoCancelamento) {
        this.cancelamento = nFInfoCancelamento;
    }

    public DFUnidadeFederativa getOrgao() {
        return this.orgao;
    }
}

