/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class NFTipoEvento
extends DFBase {
    private static final long serialVersionUID = 172979194017130488L;
    @Attribute(name="versao")
    private String versao;
    @Element(name="descEvento")
    private String descricaoEvento;
    @Element(name="xCorrecao", required=false)
    private String textoCorrecao;
    @Element(name="xCondUso", required=false)
    private String condicaoUso;

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = BigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao");
    }

    public void setDescricaoEvento(String string) {
        StringValidador.tamanho5a60(string, "Descricao do Evento");
        this.descricaoEvento = string;
    }

    public String getDescricaoEvento() {
        return this.descricaoEvento;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setCondicaoUso(String string) {
        this.condicaoUso = string;
    }

    public void setTextoCorrecao(String string) {
        this.textoCorrecao = string;
    }

    public String getCondicaoUso() {
        return this.condicaoUso;
    }

    public String getTextoCorrecao() {
        return this.textoCorrecao;
    }
}

