/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.statusservico.consulta.NFStatusServicoConsulta;
import com.fincatto.documentofiscal.nfe310.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe310.webservices.statusservico.consulta.NfeStatusServico2Stub;
import com.fincatto.documentofiscal.nfe310.webservices.statusservico.consulta.NfeStatusServicoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSStatusConsulta
implements DFLog {
    private static final String NOME_SERVICO = "STATUS";
    private final NFeConfig config;

    WSStatusConsulta(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFStatusServicoConsultaRetorno consultaStatus(DFUnidadeFederativa dFUnidadeFederativa, DFModelo dFModelo) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(dFUnidadeFederativa).toString());
        this.getLogger().debug(oMElement.toString());
        boolean bl = DFUnidadeFederativa.BA.equals((Object)dFUnidadeFederativa) && DFModelo.NFE.equals((Object)dFModelo);
        OMElement oMElement2 = bl ? this.efetuaConsultaStatusBahia(oMElement) : this.efetuaConsultaStatus(oMElement, dFUnidadeFederativa, dFModelo);
        this.getLogger().debug(oMElement2.toString());
        return (NFStatusServicoConsultaRetorno)this.config.getPersister().read(NFStatusServicoConsultaRetorno.class, oMElement2.toString());
    }

    private NFStatusServicoConsulta gerarDadosConsulta(DFUnidadeFederativa dFUnidadeFederativa) {
        NFStatusServicoConsulta nFStatusServicoConsulta = new NFStatusServicoConsulta();
        nFStatusServicoConsulta.setUf(dFUnidadeFederativa);
        nFStatusServicoConsulta.setAmbiente(this.config.getAmbiente());
        nFStatusServicoConsulta.setVersao(this.config.getVersao());
        nFStatusServicoConsulta.setServico(NOME_SERVICO);
        return nFStatusServicoConsulta;
    }

    private OMElement efetuaConsultaStatus(OMElement oMElement, DFUnidadeFederativa dFUnidadeFederativa, DFModelo dFModelo) throws RemoteException {
        String string;
        NfeStatusServico2Stub.NfeCabecMsg nfeCabecMsg = new NfeStatusServico2Stub.NfeCabecMsg();
        nfeCabecMsg.setCUF(dFUnidadeFederativa.getCodigoIbge());
        nfeCabecMsg.setVersaoDados(this.config.getVersao());
        NfeStatusServico2Stub.NfeCabecMsgE nfeCabecMsgE = new NfeStatusServico2Stub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        NfeStatusServico2Stub.NfeDadosMsg nfeDadosMsg = new NfeStatusServico2Stub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfCodigoUF(dFUnidadeFederativa);
        String string2 = string = DFModelo.NFCE.equals((Object)dFModelo) ? nFAutorizador31.getNfceStatusServico(this.config.getAmbiente()) : nFAutorizador31.getNfeStatusServico(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico " + dFModelo.name() + ", autorizador " + nFAutorizador31.name() + ", UF " + dFUnidadeFederativa.name());
        }
        return new NfeStatusServico2Stub(string).nfeStatusServicoNF2(nfeDadosMsg, nfeCabecMsgE).getExtraElement();
    }

    private OMElement efetuaConsultaStatusBahia(OMElement oMElement) throws RemoteException {
        NfeStatusServicoStub.NfeCabecMsg nfeCabecMsg = new NfeStatusServicoStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(DFUnidadeFederativa.BA.getCodigoIbge());
        nfeCabecMsg.setVersaoDados(this.config.getVersao());
        NfeStatusServicoStub.NfeCabecMsgE nfeCabecMsgE = new NfeStatusServicoStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        NfeStatusServicoStub.NfeDadosMsg nfeDadosMsg = new NfeStatusServicoStub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfCodigoUF(DFUnidadeFederativa.BA);
        String string = nFAutorizador31.getNfeStatusServico(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para StatusServico " + DFModelo.NFE.name() + ", autorizador " + nFAutorizador31.name() + ", UF " + DFUnidadeFederativa.BA.name());
        }
        return new NfeStatusServicoStub(string).nfeStatusServicoNF(nfeDadosMsg, nfeCabecMsgE).getExtraElement();
    }
}

