/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.evento.downloadnf.NFDownloadNFe;
import com.fincatto.documentofiscal.nfe310.classes.evento.downloadnf.NFDownloadNFeRetorno;
import com.fincatto.documentofiscal.nfe310.webservices.downloadnf.NfeDownloadNFStub;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSNotaDownload
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String NOME_SERVICO = "DOWNLOAD NFE";
    private final NFeConfig config;

    WSNotaDownload(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFDownloadNFeRetorno downloadNota(String string, String string2) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosDownloadNF(string, string2).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaDownloadNF(oMElement);
        this.getLogger().debug(oMElement2.toString());
        return (NFDownloadNFeRetorno)this.config.getPersister().read(NFDownloadNFeRetorno.class, oMElement2.toString());
    }

    private OMElement efetuaDownloadNF(OMElement oMElement) throws RemoteException {
        NfeDownloadNFStub.NfeCabecMsg nfeCabecMsg = new NfeDownloadNFStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(VERSAO_LEIAUTE.toPlainString());
        NfeDownloadNFStub.NfeCabecMsgE nfeCabecMsgE = new NfeDownloadNFStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        NfeDownloadNFStub.NfeDadosMsg nfeDadosMsg = new NfeDownloadNFStub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String string = nFAutorizador31.getNfeDownloadNF(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para DownloadNF, autorizador " + nFAutorizador31.name());
        }
        NfeDownloadNFStub.NfeDownloadNFResult nfeDownloadNFResult = new NfeDownloadNFStub(string).nfeDownloadNF(nfeDadosMsg, nfeCabecMsgE);
        return nfeDownloadNFResult.getExtraElement();
    }

    private NFDownloadNFe gerarDadosDownloadNF(String string, String string2) {
        NFDownloadNFe nFDownloadNFe = new NFDownloadNFe();
        nFDownloadNFe.setVersao(VERSAO_LEIAUTE.toPlainString());
        nFDownloadNFe.setAmbiente(this.config.getAmbiente());
        nFDownloadNFe.setServico(NOME_SERVICO);
        nFDownloadNFe.setCnpj(string);
        nFDownloadNFe.setChave(string2);
        return nFDownloadNFe;
    }
}

