/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFProtocolo;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNota;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="nfeProc")
@Namespace(reference="http://www.portalfiscal.inf.br/nfe")
public class NFNotaProcessada
extends DFBase {
    private static final long serialVersionUID = 6979476565566044621L;
    @Attribute(name="versao")
    private String versao;
    @Attribute(name="schemaLocation", required=false)
    private String schemaLocation;
    @Element(name="NFe")
    private NFNota nota;
    @Element(name="protNFe")
    private NFProtocolo protocolo;

    public NFNota getNota() {
        return this.nota;
    }

    public String getVersao() {
        return this.versao;
    }

    public NFProtocolo getProtocolo() {
        return this.protocolo;
    }

    public void setNota(NFNota nFNota) {
        this.nota = nFNota;
    }

    public void setProtocolo(NFProtocolo nFProtocolo) {
        this.protocolo = nFProtocolo;
    }

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = BigDecimalValidador.tamanho4Com2CasasDecimais(bigDecimal, "Versao Nota Processada");
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }
}

