/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFFormaImportacaoIntermediacao;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFViaTransporteInternacional;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;

public class NFNotaInfoItemProdutoDeclaracaoImportacao
extends DFBase {
    private static final long serialVersionUID = 4173954108879768633L;
    @Element(name="nDI")
    private String numeroRegistro;
    @Element(name="dDI")
    private LocalDate dataRegistro;
    @Element(name="xLocDesemb")
    private String localDesembaraco;
    @Element(name="UFDesemb")
    private String ufDesembaraco;
    @Element(name="dDesemb")
    private LocalDate dataDesembaraco;
    @Element(name="tpViaTransp")
    private NFViaTransporteInternacional transporteInternacional;
    @Element(name="vAFRMM", required=false)
    private String valorAFRMM;
    @Element(name="tpIntermedio")
    private NFFormaImportacaoIntermediacao formaImportacaoIntermediacao;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="UFTerceiro", required=false)
    private String ufTerceiro;
    @Element(name="cExportador")
    private String codigoExportador;
    @ElementList(entry="adi", inline=true)
    private List<NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao> adicoes;

    public void setNumeroRegistro(String string) {
        StringValidador.tamanho12(string, "Numero Registro Declaracao Importacao");
        this.numeroRegistro = string;
    }

    public void setDataRegistro(LocalDate localDate) {
        this.dataRegistro = localDate;
    }

    public void setLocalDesembaraco(String string) {
        StringValidador.tamanho60(string, "Desembaraco Declaracao Importacao");
        this.localDesembaraco = string;
    }

    public void setUfDesembaraco(DFUnidadeFederativa dFUnidadeFederativa) {
        this.ufDesembaraco = dFUnidadeFederativa.getCodigo();
    }

    public void setDataDesembaraco(LocalDate localDate) {
        this.dataDesembaraco = localDate;
    }

    public void setCodigoExportador(String string) {
        StringValidador.tamanho60(string, "Codigo Exportador Declaracao Importacao");
        this.codigoExportador = string;
    }

    public void setAdicoes(List<NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao> list) {
        this.adicoes = list;
    }

    public void setTransporteInternacional(NFViaTransporteInternacional nFViaTransporteInternacional) {
        this.transporteInternacional = nFViaTransporteInternacional;
    }

    public void setValorAFRMM(BigDecimal bigDecimal) {
        this.valorAFRMM = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor AFRMM Declaracao Importacao");
    }

    public void setFormaImportacaoIntermediacao(NFFormaImportacaoIntermediacao nFFormaImportacaoIntermediacao) {
        this.formaImportacaoIntermediacao = nFFormaImportacaoIntermediacao;
    }

    public void setCnpj(String string) {
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public void setUfTerceiro(DFUnidadeFederativa dFUnidadeFederativa) {
        this.ufTerceiro = dFUnidadeFederativa.getCodigo();
    }

    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    public LocalDate getDataRegistro() {
        return this.dataRegistro;
    }

    public String getLocalDesembaraco() {
        return this.localDesembaraco;
    }

    public String getUfDesembaraco() {
        return this.ufDesembaraco;
    }

    public LocalDate getDataDesembaraco() {
        return this.dataDesembaraco;
    }

    public NFViaTransporteInternacional getTransporteInternacional() {
        return this.transporteInternacional;
    }

    public String getValorAFRMM() {
        return this.valorAFRMM;
    }

    public NFFormaImportacaoIntermediacao getFormaImportacaoIntermediacao() {
        return this.formaImportacaoIntermediacao;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getUfTerceiro() {
        return this.ufTerceiro;
    }

    public String getCodigoExportador() {
        return this.codigoExportador;
    }

    public List<NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao> getAdicoes() {
        return this.adicoes;
    }
}

