/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoCOFINSST
extends DFBase {
    private static final long serialVersionUID = -5116872172037197633L;
    @Element(name="vBC", required=false)
    private String valorBaseCalculo = null;
    @Element(name="pCOFINS", required=false)
    private String percentualAliquota = null;
    @Element(name="qBCProd", required=false)
    private String quantidadeVendida = null;
    @Element(name="vAliqProd", required=false)
    private String valorAliquotaCOFINS = null;
    @Element(name="vCOFINS")
    private String valorCOFINS = null;

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        if (this.quantidadeVendida != null || this.valorAliquotaCOFINS != null) {
            throw new IllegalStateException("Ja foi setado quantidade vendida ou valor aliquota COFINS");
        }
        this.valorBaseCalculo = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Base Calculo COFINS ST Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        if (this.quantidadeVendida != null || this.valorAliquotaCOFINS != null) {
            throw new IllegalStateException("Ja foi setado quantidade vendida ou valor aliquota COFINS");
        }
        this.percentualAliquota = BigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota COFINS ST Item");
    }

    public void setQuantidadeVendida(BigDecimal bigDecimal) {
        if (this.valorBaseCalculo != null || this.percentualAliquota != null) {
            throw new IllegalStateException("Ja foi setado valor da base de calculo ou percentual aliquota COFINS");
        }
        this.quantidadeVendida = BigDecimalValidador.tamanho16ComAte4CasasDecimais(bigDecimal, "Quantidade COFINS ST Item");
    }

    public void setValorAliquotaCOFINS(BigDecimal bigDecimal) {
        if (this.valorBaseCalculo != null || this.percentualAliquota != null) {
            throw new IllegalStateException("Ja foi setado valor da base de calculo ou percentual aliquota COFINS");
        }
        this.valorAliquotaCOFINS = BigDecimalValidador.tamanho15Com4CasasDecimais(bigDecimal, "Valor Aliquota COFINS ST Item");
    }

    public void setValorCOFINS(BigDecimal bigDecimal) {
        this.valorCOFINS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Tributo COFINS ST Item");
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getQuantidadeVendida() {
        return this.quantidadeVendida;
    }

    public String getValorAliquotaCOFINS() {
        return this.valorAliquotaCOFINS;
    }

    public String getValorCOFINS() {
        return this.valorCOFINS;
    }
}

