/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoCOFINS;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoCOFINSST;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoICMS;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoICMSUFDestino;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoIPI;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoISSQN;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoImportacao;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoPIS;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemImpostoPISST;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImposto
extends DFBase {
    private static final long serialVersionUID = 8579628067567740408L;
    @Element(name="vTotTrib", required=false)
    private String valorTotalTributos;
    @Element(name="ICMS", required=false)
    private NFNotaInfoItemImpostoICMS icms;
    @Element(name="IPI", required=false)
    private NFNotaInfoItemImpostoIPI ipi;
    @Element(name="II", required=false)
    private NFNotaInfoItemImpostoImportacao impostoImportacao;
    @Element(name="ISSQN", required=false)
    private NFNotaInfoItemImpostoISSQN issqn;
    @Element(name="PIS", required=false)
    private NFNotaInfoItemImpostoPIS pis;
    @Element(name="PISST", required=false)
    private NFNotaInfoItemImpostoPISST pisst;
    @Element(name="COFINS", required=false)
    private NFNotaInfoItemImpostoCOFINS cofins;
    @Element(name="COFINSST", required=false)
    private NFNotaInfoItemImpostoCOFINSST cofinsst;
    @Element(name="ICMSUFDest", required=false)
    private NFNotaInfoItemImpostoICMSUFDestino icmsUfDestino;

    public void setIcms(NFNotaInfoItemImpostoICMS nFNotaInfoItemImpostoICMS) {
        if (this.issqn != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        this.icms = nFNotaInfoItemImpostoICMS;
    }

    public void setIpi(NFNotaInfoItemImpostoIPI nFNotaInfoItemImpostoIPI) {
        if (this.issqn != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        this.ipi = nFNotaInfoItemImpostoIPI;
    }

    public void setImpostoImportacao(NFNotaInfoItemImpostoImportacao nFNotaInfoItemImpostoImportacao) {
        if (this.issqn != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        this.impostoImportacao = nFNotaInfoItemImpostoImportacao;
    }

    public void setIssqn(NFNotaInfoItemImpostoISSQN nFNotaInfoItemImpostoISSQN) {
        if (this.icms != null || this.ipi != null || this.impostoImportacao != null) {
            throw new IllegalStateException("ICMS, IPI e II sao mutuamente exclusivo com ISSQN");
        }
        this.issqn = nFNotaInfoItemImpostoISSQN;
    }

    public void setPis(NFNotaInfoItemImpostoPIS nFNotaInfoItemImpostoPIS) {
        this.pis = nFNotaInfoItemImpostoPIS;
    }

    public void setPisst(NFNotaInfoItemImpostoPISST nFNotaInfoItemImpostoPISST) {
        this.pisst = nFNotaInfoItemImpostoPISST;
    }

    public void setCofins(NFNotaInfoItemImpostoCOFINS nFNotaInfoItemImpostoCOFINS) {
        this.cofins = nFNotaInfoItemImpostoCOFINS;
    }

    public void setCofinsst(NFNotaInfoItemImpostoCOFINSST nFNotaInfoItemImpostoCOFINSST) {
        this.cofinsst = nFNotaInfoItemImpostoCOFINSST;
    }

    public void setValorTotalTributos(BigDecimal bigDecimal) {
        this.valorTotalTributos = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Tributos");
    }

    public String getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    public NFNotaInfoItemImpostoICMS getIcms() {
        return this.icms;
    }

    public NFNotaInfoItemImpostoIPI getIpi() {
        return this.ipi;
    }

    public NFNotaInfoItemImpostoImportacao getImpostoImportacao() {
        return this.impostoImportacao;
    }

    public NFNotaInfoItemImpostoISSQN getIssqn() {
        return this.issqn;
    }

    public NFNotaInfoItemImpostoPIS getPis() {
        return this.pis;
    }

    public NFNotaInfoItemImpostoPISST getPisst() {
        return this.pisst;
    }

    public NFNotaInfoItemImpostoCOFINS getCofins() {
        return this.cofins;
    }

    public NFNotaInfoItemImpostoCOFINSST getCofinsst() {
        return this.cofinsst;
    }

    public NFNotaInfoItemImpostoICMSUFDestino getIcmsUfDestino() {
        return this.icmsUfDestino;
    }

    public void setIcmsUfDestino(NFNotaInfoItemImpostoICMSUFDestino nFNotaInfoItemImpostoICMSUFDestino) {
        this.icmsUfDestino = nFNotaInfoItemImpostoICMSUFDestino;
    }
}

