/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoICMSTotal
extends DFBase {
    private static final long serialVersionUID = 1644701343314788528L;
    @Element(name="vBC")
    private String baseCalculoICMS;
    @Element(name="vICMS")
    private String valorTotalICMS;
    @Element(name="vICMSDeson")
    private String valorICMSDesonerado;
    @Element(name="vFCPUFDest", required=false)
    private String valorICMSFundoCombatePobreza;
    @Element(name="vICMSUFDest", required=false)
    private String valorICMSPartilhaDestinatario;
    @Element(name="vICMSUFRemet", required=false)
    private String valorICMSPartilhaRementente;
    @Element(name="vBCST")
    private String baseCalculoICMSST;
    @Element(name="vST")
    private String valorTotalICMSST;
    @Element(name="vProd")
    private String valorTotalDosProdutosServicos;
    @Element(name="vFrete")
    private String valorTotalFrete;
    @Element(name="vSeg")
    private String valorTotalSeguro;
    @Element(name="vDesc")
    private String valorTotalDesconto;
    @Element(name="vII")
    private String valorTotalII;
    @Element(name="vIPI")
    private String valorTotalIPI;
    @Element(name="vPIS")
    private String valorPIS;
    @Element(name="vCOFINS")
    private String valorCOFINS;
    @Element(name="vOutro")
    private String outrasDespesasAcessorias;
    @Element(name="vNF")
    private String valorTotalNFe;
    @Element(name="vTotTrib", required=false)
    private String valorTotalTributos;

    public void setBaseCalculoICMS(BigDecimal bigDecimal) {
        this.baseCalculoICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Base de Calculo ICMS Total");
    }

    public void setValorTotalICMS(BigDecimal bigDecimal) {
        this.valorTotalICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valalor Total ICMS");
    }

    public void setBaseCalculoICMSST(BigDecimal bigDecimal) {
        this.baseCalculoICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Base de Calculo ICMS ST Total");
    }

    public void setValorTotalICMSST(BigDecimal bigDecimal) {
        this.valorTotalICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total ICMS ST");
    }

    public void setValorTotalDosProdutosServicos(BigDecimal bigDecimal) {
        this.valorTotalDosProdutosServicos = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Produtos e Servicos");
    }

    public void setValorTotalFrete(BigDecimal bigDecimal) {
        this.valorTotalFrete = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Frete");
    }

    public void setValorTotalSeguro(BigDecimal bigDecimal) {
        this.valorTotalSeguro = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Seguro");
    }

    public void setValorTotalDesconto(BigDecimal bigDecimal) {
        this.valorTotalDesconto = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Desconto");
    }

    public void setValorTotalII(BigDecimal bigDecimal) {
        this.valorTotalII = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total II");
    }

    public void setValorTotalIPI(BigDecimal bigDecimal) {
        this.valorTotalIPI = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total IPI");
    }

    public void setValorPIS(BigDecimal bigDecimal) {
        this.valorPIS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total PIS");
    }

    public void setValorCOFINS(BigDecimal bigDecimal) {
        this.valorCOFINS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total COFINS");
    }

    public void setOutrasDespesasAcessorias(BigDecimal bigDecimal) {
        this.outrasDespesasAcessorias = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Outras Despesas Acessorias");
    }

    public void setValorTotalNFe(BigDecimal bigDecimal) {
        this.valorTotalNFe = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total NFe");
    }

    public void setValorTotalTributos(BigDecimal bigDecimal) {
        this.valorTotalTributos = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total Tributos");
    }

    public void setValorICMSDesonerado(BigDecimal bigDecimal) {
        this.valorICMSDesonerado = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Desonerado");
    }

    public String getBaseCalculoICMS() {
        return this.baseCalculoICMS;
    }

    public String getValorTotalICMS() {
        return this.valorTotalICMS;
    }

    public String getValorICMSDesonerado() {
        return this.valorICMSDesonerado;
    }

    public String getBaseCalculoICMSST() {
        return this.baseCalculoICMSST;
    }

    public String getValorTotalICMSST() {
        return this.valorTotalICMSST;
    }

    public String getValorTotalDosProdutosServicos() {
        return this.valorTotalDosProdutosServicos;
    }

    public String getValorTotalFrete() {
        return this.valorTotalFrete;
    }

    public String getValorTotalSeguro() {
        return this.valorTotalSeguro;
    }

    public String getValorTotalDesconto() {
        return this.valorTotalDesconto;
    }

    public String getValorTotalII() {
        return this.valorTotalII;
    }

    public String getValorTotalIPI() {
        return this.valorTotalIPI;
    }

    public String getValorPIS() {
        return this.valorPIS;
    }

    public String getValorCOFINS() {
        return this.valorCOFINS;
    }

    public String getOutrasDespesasAcessorias() {
        return this.outrasDespesasAcessorias;
    }

    public String getValorTotalNFe() {
        return this.valorTotalNFe;
    }

    public String getValorTotalTributos() {
        return this.valorTotalTributos;
    }

    public String getValorICMSFundoCombatePobreza() {
        return this.valorICMSFundoCombatePobreza;
    }

    public void setValorICMSFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorICMSFundoCombatePobreza = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Fundo Combate a Pobreza");
    }

    public String getValorICMSPartilhaDestinatario() {
        return this.valorICMSPartilhaDestinatario;
    }

    public void setValorICMSPartilhaDestinatario(BigDecimal bigDecimal) {
        this.valorICMSPartilhaDestinatario = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Partilha Destinatario");
    }

    public String getValorICMSPartilhaRementente() {
        return this.valorICMSPartilhaRementente;
    }

    public void setValorICMSPartilhaRementente(BigDecimal bigDecimal) {
        this.valorICMSPartilhaRementente = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Partilha Remetente");
    }
}

