/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.IntegerValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;

public class NFInfoProdutorRuralReferenciada
extends DFBase {
    private static final long serialVersionUID = -2718285687811273188L;
    @Element(name="cUF")
    private DFUnidadeFederativa ufEmitente;
    @Element(name="AAMM")
    private String anoMesEmissao;
    @Element(name="CNPJ", required=false)
    private String cnpjEmitente;
    @Element(name="CPF", required=false)
    private String cpfEmitente;
    @Element(name="IE")
    private String ieEmitente;
    @Element(name="mod")
    private String modeloDocumentoFiscal;
    @Element(name="serie")
    private Integer serieDocumentoFiscal;
    @Element(name="nNF")
    private Integer numeroDocumentoFiscal;

    public void setUfEmitente(DFUnidadeFederativa dFUnidadeFederativa) {
        this.ufEmitente = dFUnidadeFederativa;
    }

    public void setAnoMesEmissao(String string) {
        StringValidador.aamm(string);
        this.anoMesEmissao = string;
    }

    public void setCnpjEmitente(String string) {
        if (this.cpfEmitente != null) {
            throw new IllegalStateException("Nao pode setar CNPJ pois CPF ja esta setado");
        }
        StringValidador.cnpj(string);
        this.cnpjEmitente = string;
    }

    public void setCpfEmitente(String string) {
        if (this.cnpjEmitente != null) {
            throw new IllegalStateException("Nao pode setar CPF pois CNPJ ja esta setado");
        }
        StringValidador.cpf(string);
        this.cpfEmitente = string;
    }

    public void setIeEmitente(String string) {
        StringValidador.inscricaoEstadual(string);
        this.ieEmitente = string;
    }

    public void setModeloDocumentoFiscal(String string) {
        StringValidador.exatamente2(string, "Modelo Documento Fiscal");
        this.modeloDocumentoFiscal = string;
    }

    public void setSerieDocumentoFiscal(Integer n) {
        IntegerValidador.tamanho3(n, "Serie Documento Fiscal");
        this.serieDocumentoFiscal = n;
    }

    public void setNumeroDocumentoFiscal(Integer n) {
        IntegerValidador.tamanho9(n, "Numero Documento Fiscal");
        this.numeroDocumentoFiscal = n;
    }

    public DFUnidadeFederativa getUfEmitente() {
        return this.ufEmitente;
    }

    public String getAnoMesEmissao() {
        return this.anoMesEmissao;
    }

    public String getCnpjEmitente() {
        return this.cnpjEmitente;
    }

    public String getCpfEmitente() {
        return this.cpfEmitente;
    }

    public String getIeEmitente() {
        return this.ieEmitente;
    }

    public String getModeloDocumentoFiscal() {
        return this.modeloDocumentoFiscal;
    }

    public Integer getSerieDocumentoFiscal() {
        return this.serieDocumentoFiscal;
    }

    public Integer getNumeroDocumentoFiscal() {
        return this.numeroDocumentoFiscal;
    }
}

