/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.webservices;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe3.MDFeConfig;
import com.fincatto.documentofiscal.mdfe3.classes.consultaRecibo.MDFeConsultaReciboRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.consultanaoencerrados.MDFeConsultaNaoEncerradosRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.consultastatusservico.MDFeConsStatServRet;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLote;
import com.fincatto.documentofiscal.mdfe3.classes.lote.envio.MDFEnvioLoteRetornoDados;
import com.fincatto.documentofiscal.mdfe3.classes.nota.consulta.MDFeNotaConsultaRetorno;
import com.fincatto.documentofiscal.mdfe3.classes.nota.evento.MDFeRetorno;
import com.fincatto.documentofiscal.mdfe3.webservices.WSCancelamento;
import com.fincatto.documentofiscal.mdfe3.webservices.WSConsultaNaoEncerrados;
import com.fincatto.documentofiscal.mdfe3.webservices.WSConsultaRecibo;
import com.fincatto.documentofiscal.mdfe3.webservices.WSEncerramento;
import com.fincatto.documentofiscal.mdfe3.webservices.WSIncluirCondutor;
import com.fincatto.documentofiscal.mdfe3.webservices.WSNotaConsulta;
import com.fincatto.documentofiscal.mdfe3.webservices.WSRecepcaoLote;
import com.fincatto.documentofiscal.mdfe3.webservices.WSStatusConsulta;
import com.fincatto.documentofiscal.utils.DFSocketFactory;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.LocalDate;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class WSFacade {
    private final WSStatusConsulta wsStatusConsulta;
    private final WSRecepcaoLote wsRecepcaoLote;
    private final WSNotaConsulta wsNotaConsulta;
    private final WSCancelamento wsCancelamento;
    private final WSEncerramento wsEncerramento;
    private final WSConsultaRecibo wsConsultaRecibo;
    private final WSConsultaNaoEncerrados wsConsultaNaoEncerrados;
    private final WSIncluirCondutor wsIncluirCondutor;

    public WSFacade(MDFeConfig mDFeConfig) throws IOException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new DFSocketFactory(mDFeConfig), 443));
        this.wsStatusConsulta = new WSStatusConsulta(mDFeConfig);
        this.wsRecepcaoLote = new WSRecepcaoLote(mDFeConfig);
        this.wsNotaConsulta = new WSNotaConsulta(mDFeConfig);
        this.wsCancelamento = new WSCancelamento(mDFeConfig);
        this.wsEncerramento = new WSEncerramento(mDFeConfig);
        this.wsConsultaRecibo = new WSConsultaRecibo(mDFeConfig);
        this.wsConsultaNaoEncerrados = new WSConsultaNaoEncerrados(mDFeConfig);
        this.wsIncluirCondutor = new WSIncluirCondutor(mDFeConfig);
    }

    public MDFEnvioLoteRetornoDados envioRecepcaoLote(MDFEnvioLote mDFEnvioLote) throws Exception {
        return this.wsRecepcaoLote.envioRecepcao(mDFEnvioLote);
    }

    public MDFeConsStatServRet consultaStatus(DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        return this.wsStatusConsulta.consultaStatus(dFUnidadeFederativa);
    }

    public MDFeConsStatServRet consultaStatus() throws Exception {
        return this.wsStatusConsulta.consultaStatus(DFUnidadeFederativa.RS);
    }

    public MDFeNotaConsultaRetorno consultaMdfe(String string) throws Exception {
        return this.wsNotaConsulta.consultaNota(string);
    }

    public MDFeRetorno cancelaMdfe(String string, String string2, String string3) throws Exception {
        return this.wsCancelamento.cancelaNota(string, string2, string3);
    }

    public MDFeRetorno cancelaMdfeAssinado(String string, String string2) throws Exception {
        return this.wsCancelamento.cancelaNotaAssinada(string, string2);
    }

    public MDFeRetorno encerramento(String string, String string2, String string3, LocalDate localDate, DFUnidadeFederativa dFUnidadeFederativa) throws Exception {
        return this.wsEncerramento.encerraMdfe(string, string2, string3, localDate, dFUnidadeFederativa);
    }

    public MDFeRetorno encerramentoAssinado(String string, String string2) throws Exception {
        return this.wsEncerramento.encerramentoMdfeAssinado(string, string2);
    }

    public MDFeConsultaReciboRetorno consultaRecibo(String string) throws Exception {
        return this.wsConsultaRecibo.consultaRecibo(string);
    }

    public MDFeConsultaNaoEncerradosRetorno consultaNaoEncerrados(String string) throws Exception {
        return this.wsConsultaNaoEncerrados.consultaNaoEncerrados(string);
    }

    public MDFeRetorno incluirCondutor(String string, String string2, String string3) throws Exception {
        return this.wsIncluirCondutor.incluirCondutor(string, string2, string3);
    }

    public MDFeRetorno incluirCondutorAssinado(String string, String string2) throws Exception {
        return this.wsIncluirCondutor.incluirCondutorAssinado(string, string2);
    }
}

