/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota.evento;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.time.LocalDate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="evEncMDFe")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFeEnviaEventoEncerramento
extends DFBase {
    private static final long serialVersionUID = -6894944230355205786L;
    @Element(name="descEvento")
    private String descricaoEvento = "Encerramento";
    @Element(name="nProt")
    private String protocoloAutorizacao;
    @Element(name="dtEnc")
    private LocalDate dataEncerramento;
    @Element(name="cUF")
    private DFUnidadeFederativa uf;
    @Element(name="cMun")
    private String codigoMunicipio;

    public void setProtocoloAutorizacao(String string) {
        StringValidador.exatamente15N(string, "Protocolo de Autorizacao");
        this.protocoloAutorizacao = string;
    }

    public String getProtocoloAutorizacao() {
        return this.protocoloAutorizacao;
    }

    public void setDescricaoEvento(String string) {
        StringValidador.equals("Encerramento", string);
        this.descricaoEvento = string;
    }

    public String getDescricaoEvento() {
        return this.descricaoEvento;
    }

    public DFUnidadeFederativa getUf() {
        return this.uf;
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa;
    }

    public String getCodigoMunicipio() {
        return this.codigoMunicipio;
    }

    public void setCodigoMunicipio(String string) {
        this.codigoMunicipio = string;
    }

    public LocalDate getDataEncerramento() {
        return this.dataEncerramento;
    }

    public void setDataEncerramento(LocalDate localDate) {
        this.dataEncerramento = localDate;
    }
}

