/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFModalidadeTransporte;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFProcessoEmissao;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoEmissao;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoEmitente;
import com.fincatto.documentofiscal.mdfe3.classes.def.MDFTipoTranportador;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoIdentificacaoMunicipioCarregamento;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoIdentificacaoUfPercurso;
import com.fincatto.documentofiscal.validadores.IntegerValidador;
import com.fincatto.documentofiscal.validadores.ListValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ide")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = -106178398166932545L;
    @Element(name="cUF")
    private DFUnidadeFederativa codigoUF;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="tpEmit")
    private MDFTipoEmitente tipoEmitente;
    @Element(name="tpTransp", required=false)
    private MDFTipoTranportador tipoTranportador;
    @Element(name="mod")
    public static final DFModelo MOD = DFModelo.MDFE;
    @Element(name="serie")
    private Integer serie;
    @Element(name="nMDF")
    private Integer numero;
    @Element(name="cMDF")
    private String codigoNumerico;
    @Element(name="cDV")
    private Integer digitoVerificador;
    @Element(name="modal")
    private MDFModalidadeTransporte modalidadeFrete;
    @Element(name="dhEmi")
    private ZonedDateTime dataEmissao;
    @Element(name="tpEmis")
    private MDFTipoEmissao tipoEmissao;
    @Element(name="procEmi")
    private MDFProcessoEmissao processoEmissao;
    @Element(name="verProc")
    private String versaoProcessoEmissao;
    @Element(name="UFIni")
    private String unidadeFederativaInicio;
    @Element(name="UFFim")
    private String unidadeFederativaFim;
    @ElementList(entry="infMunCarrega", inline=true)
    private List<MDFInfoIdentificacaoMunicipioCarregamento> municipioCarregamentos;
    @ElementList(entry="infPercurso", inline=true, required=false)
    private List<MDFInfoIdentificacaoUfPercurso> identificacaoUfPercursos;
    @Element(name="dhIniViagem", required=false)
    private ZonedDateTime dataHoraDoInicioViagem;
    @Element(name="indCanalVerde", required=false)
    private String indicadorCanalVerde;

    public DFUnidadeFederativa getCodigoUF() {
        return this.codigoUF;
    }

    public void setCodigoUF(DFUnidadeFederativa dFUnidadeFederativa) {
        this.codigoUF = dFUnidadeFederativa;
    }

    public String getCodigoNumerico() {
        return this.codigoNumerico;
    }

    public void setCodigoNumerico(String string) {
        StringValidador.exatamente8N(string, "C\u00f3digo Num\u00e9rico");
        this.codigoNumerico = string;
    }

    public Integer getSerie() {
        return this.serie;
    }

    public void setSerie(Integer n) {
        IntegerValidador.tamanho3(n, "S\u00e9rie");
        this.serie = n;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer n) {
        IntegerValidador.tamanho9(n, "N\u00famero");
        this.numero = n;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime zonedDateTime) {
        this.dataEmissao = zonedDateTime;
    }

    public MDFTipoEmissao getTipoEmissao() {
        return this.tipoEmissao;
    }

    public void setTipoEmissao(MDFTipoEmissao mDFTipoEmissao) {
        this.tipoEmissao = mDFTipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer n) {
        IntegerValidador.exatamente1(n, "Digito verificador MDF-e");
        this.digitoVerificador = n;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public MDFProcessoEmissao getProcessoEmissao() {
        return this.processoEmissao;
    }

    public void setProcessoEmissao(MDFProcessoEmissao mDFProcessoEmissao) {
        this.processoEmissao = mDFProcessoEmissao;
    }

    public String getVersaoProcessoEmissao() {
        return this.versaoProcessoEmissao;
    }

    public void setVersaoProcessoEmissao(String string) {
        StringValidador.tamanho20(string, "Vers\u00e3o Aplicativo Emissor");
        this.versaoProcessoEmissao = string;
    }

    public MDFModalidadeTransporte getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public void setModalidadeFrete(MDFModalidadeTransporte mDFModalidadeTransporte) {
        this.modalidadeFrete = mDFModalidadeTransporte;
    }

    public MDFTipoEmitente getTipoEmitente() {
        return this.tipoEmitente;
    }

    public void setTipoEmitente(MDFTipoEmitente mDFTipoEmitente) {
        this.tipoEmitente = mDFTipoEmitente;
    }

    public MDFTipoTranportador getTipoTranportador() {
        return this.tipoTranportador;
    }

    public void setTipoTranportador(MDFTipoTranportador mDFTipoTranportador) {
        this.tipoTranportador = mDFTipoTranportador;
    }

    public String getUnidadeFederativaInicio() {
        return this.unidadeFederativaInicio;
    }

    public void setUnidadeFederativaInicio(DFUnidadeFederativa dFUnidadeFederativa) {
        this.unidadeFederativaInicio = dFUnidadeFederativa.getCodigo();
    }

    public String getUnidadeFederativaFim() {
        return this.unidadeFederativaFim;
    }

    public void setUnidadeFederativaFim(DFUnidadeFederativa dFUnidadeFederativa) {
        this.unidadeFederativaFim = dFUnidadeFederativa.getCodigo();
    }

    public List<MDFInfoIdentificacaoMunicipioCarregamento> getMunicipioCarregamentos() {
        return this.municipioCarregamentos;
    }

    public void setMunicipioCarregamentos(List<MDFInfoIdentificacaoMunicipioCarregamento> list) {
        this.municipioCarregamentos = ListValidador.validaListaObrigatoria(list, 50, "Munic\u00edpios carregamento MDF-e");
    }

    public List<MDFInfoIdentificacaoUfPercurso> getIdentificacaoUfPercursos() {
        return this.identificacaoUfPercursos;
    }

    public void setIdentificacaoUfPercursos(List<MDFInfoIdentificacaoUfPercurso> list) {
        this.identificacaoUfPercursos = ListValidador.validaListaNaoObrigatoria(list, 25, "UF percurso MDF-e");
    }

    public ZonedDateTime getDataHoraDoInicioViagem() {
        return this.dataHoraDoInicioViagem;
    }

    public void setDataHoraDoInicioViagem(ZonedDateTime zonedDateTime) {
        this.dataHoraDoInicioViagem = zonedDateTime;
    }

    public String getIndicadorCanalVerde() {
        return this.indicadorCanalVerde;
    }

    public void setIndicadorCanalVerde(String string) {
        Object[] objectArray = new String[]{"1"};
        if (StringUtils.isNotBlank((CharSequence)string) && !StringUtils.equalsAny((CharSequence)string, (CharSequence[])objectArray)) {
            throw new IllegalStateException(String.format("Indicador canal verde \"%s\" deve possuir um dos seguintes:'%s' caracteres", string, Arrays.toString(objectArray)));
        }
        this.indicadorCanalVerde = string;
    }
}

