/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoEmitenteEndereco;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="emit")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfoEmitente
extends DFBase {
    private static final long serialVersionUID = 6209368588212530094L;
    private static final String INFO = "Emitente do Manifesto";
    @Element(name="CNPJ")
    private String cnpj;
    @Element(name="IE")
    private String inscricaoEstadual;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="xFant", required=false)
    private String nomeFantasia;
    @Element(name="enderEmit")
    private MDFInfoEmitenteEndereco endereco;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        this.cnpj = StringValidador.cnpj(string, INFO);
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String string) {
        this.inscricaoEstadual = StringValidador.inscricaoEstadualSemIsencao(string, INFO);
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String string) {
        StringValidador.tamanho2ate60(string, "Raz\u00e3o social ou Nome em Emitente do Manifesto");
        this.razaoSocial = string;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String string) {
        StringValidador.tamanho2ate60(string, "Nome fantasia em Emitente do Manifesto");
        this.nomeFantasia = string;
    }

    public MDFInfoEmitenteEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(MDFInfoEmitenteEndereco mDFInfoEmitenteEndereco) {
        this.endereco = mDFInfoEmitenteEndereco;
    }
}

