/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="autXML")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfoAutorizacaoDownload
extends DFBase {
    private static final long serialVersionUID = -5711457880712720488L;
    private static final String INFO = "Autorizacao Download MDFe";
    @Element(name="CNPJ", required=false)
    private String cnpj = null;
    @Element(name="CPF", required=false)
    private String cpf = null;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        if (this.cpf != null) {
            throw new IllegalStateException("Nao deve setar CNPJ se CPF esteja setado em Autorizacao Download MDFe");
        }
        this.cnpj = StringValidador.cnpj(string, INFO);
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        if (this.cnpj != null) {
            throw new IllegalStateException("Nao deve setar CPF se CNPJ esteja setado em Autorizacao Download MDFe");
        }
        this.cpf = StringValidador.cpf(string, INFO);
    }
}

