/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoAutorizacaoDownload;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoEmitente;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoIdentificacao;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoInformacoesAdicionais;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoInformacoesDocumentos;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoLacre1A60;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoModal;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoSeguro;
import com.fincatto.documentofiscal.mdfe3.classes.nota.MDFInfoTotal;
import com.fincatto.documentofiscal.validadores.ListValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infMDFe")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFInfo
extends DFBase {
    private static final long serialVersionUID = 5215463851140624452L;
    public static final String IDENT = "MDFe";
    @Attribute(name="Id")
    private String identificador;
    @Attribute(name="versao")
    private String versao = "3.00";
    @Element(name="ide")
    private MDFInfoIdentificacao identificacao;
    @Element(name="emit")
    private MDFInfoEmitente emitente;
    @Element(name="infModal")
    private MDFInfoModal mdfInfoModal;
    @Element(name="infDoc")
    private MDFInfoInformacoesDocumentos informacoesDocumentos;
    @ElementList(name="seg", inline=true, required=false)
    private List<MDFInfoSeguro> seguro;
    @Element(name="tot")
    private MDFInfoTotal infoTotal;
    @ElementList(entry="lacres", inline=true, required=false)
    private List<MDFInfoLacre1A60> lacres;
    @ElementList(name="autXML", inline=true, required=false)
    private List<MDFInfoAutorizacaoDownload> autorizacaoDownload;
    @Element(name="infAdic", required=false)
    private MDFInfoInformacoesAdicionais informacoesAdicionais;

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String string) {
        StringValidador.exatamente44N(string, "Identificador");
        this.identificador = IDENT + string;
    }

    public String getChaveAcesso() {
        return this.identificador.replace(IDENT, "");
    }

    public MDFInfoIdentificacao getIdentificacao() {
        return this.identificacao;
    }

    public MDFInfoEmitente getEmitente() {
        return this.emitente;
    }

    public void setEmitente(MDFInfoEmitente mDFInfoEmitente) {
        this.emitente = mDFInfoEmitente;
    }

    public List<MDFInfoAutorizacaoDownload> getAutorizacaoDownload() {
        return this.autorizacaoDownload;
    }

    public void setAutorizacaoDownload(List<MDFInfoAutorizacaoDownload> list) {
        ListValidador.tamanho10(list, "Autorizados para download do XML do DF-e");
        this.autorizacaoDownload = list;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String string) {
        StringValidador.equals("3.00", string);
        this.versao = string;
    }

    public void setIdentificacao(MDFInfoIdentificacao mDFInfoIdentificacao) {
        this.identificacao = mDFInfoIdentificacao;
    }

    public MDFInfoModal getMdfInfoModal() {
        return this.mdfInfoModal;
    }

    public void setMdfInfoModal(MDFInfoModal mDFInfoModal) {
        this.mdfInfoModal = mDFInfoModal;
    }

    public MDFInfoInformacoesDocumentos getInformacoesDocumentos() {
        return this.informacoesDocumentos;
    }

    public void setInformacoesDocumentos(MDFInfoInformacoesDocumentos mDFInfoInformacoesDocumentos) {
        this.informacoesDocumentos = mDFInfoInformacoesDocumentos;
    }

    public MDFInfoTotal getInfoTotal() {
        return this.infoTotal;
    }

    public void setInfoTotal(MDFInfoTotal mDFInfoTotal) {
        this.infoTotal = mDFInfoTotal;
    }

    public List<MDFInfoLacre1A60> getLacres() {
        return this.lacres;
    }

    public void setLacres(List<MDFInfoLacre1A60> list) {
        this.lacres = list;
    }

    public MDFInfoInformacoesAdicionais getInformacoesAdicionais() {
        return this.informacoesAdicionais;
    }

    public void setInformacoesAdicionais(MDFInfoInformacoesAdicionais mDFInfoInformacoesAdicionais) {
        this.informacoesAdicionais = mDFInfoInformacoesAdicionais;
    }

    public List<MDFInfoSeguro> getSeguro() {
        return this.seguro;
    }

    public void setSeguro(List<MDFInfoSeguro> list) {
        this.seguro = list;
    }
}

