/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.mdfe3.classes.consultanaoencerrados;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="consMDFeNaoEnc")
@Namespace(reference="http://www.portalfiscal.inf.br/mdfe")
public class MDFeConsultaNaoEncerrados
extends DFBase {
    private static final long serialVersionUID = -6186360215204227213L;
    @Attribute(name="versao")
    private String versao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="xServ")
    private String servico = "CONSULTAR N\u00c3O ENCERRADOS";
    @Element(name="CNPJ")
    private String cnpj;

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = BigDecimalValidador.tamanho4Com2CasasDecimais(bigDecimal, "Versao Nota Consulta");
    }

    public void setVersao(String string) {
        this.versao = string;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public void setServico(String string) {
        StringValidador.equals("CONSULTAR N\u00c3O ENCERRADOS", string);
        this.servico = string;
    }

    public String getVersao() {
        return this.versao;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public String getServico() {
        return this.servico;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        this.cnpj = StringValidador.cnpj(string, "CNPJ do emitente");
    }
}

