/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.cte300.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.CTAutorizador31;
import com.fincatto.documentofiscal.cte300.classes.enviolote.consulta.CTeConsultaRecLote;
import com.fincatto.documentofiscal.cte300.classes.enviolote.consulta.CTeConsultaRecLoteRet;
import com.fincatto.documentofiscal.cte300.webservices.retrecepcao.CteRetRecepcaoStub;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSRecepcaoLoteRetorno
implements DFLog {
    private final CTeConfig config;

    WSRecepcaoLoteRetorno(CTeConfig cTeConfig) {
        this.config = cTeConfig;
    }

    CTeConsultaRecLoteRet consultaLote(String string) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement);
        this.getLogger().debug(oMElement2.toString());
        return (CTeConsultaRecLoteRet)this.config.getPersister().read(CTeConsultaRecLoteRet.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(OMElement oMElement) throws RemoteException {
        CteRetRecepcaoStub.CteCabecMsg cteCabecMsg = new CteRetRecepcaoStub.CteCabecMsg();
        cteCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        cteCabecMsg.setVersaoDados("3.00");
        CteRetRecepcaoStub.CteCabecMsgE cteCabecMsgE = new CteRetRecepcaoStub.CteCabecMsgE();
        cteCabecMsgE.setCteCabecMsg(cteCabecMsg);
        CteRetRecepcaoStub.CteDadosMsg cteDadosMsg = new CteRetRecepcaoStub.CteDadosMsg();
        cteDadosMsg.setExtraElement(oMElement);
        CTAutorizador31 cTAutorizador31 = CTAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String string = cTAutorizador31.getCteRetRecepcao(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RetRecepcao, autorizador " + cTAutorizador31.name() + ", UF " + this.config.getCUF().name());
        }
        CteRetRecepcaoStub.CteRetRecepcaoResult cteRetRecepcaoResult = new CteRetRecepcaoStub(string).cteRetRecepcao(cteDadosMsg, cteCabecMsgE);
        return cteRetRecepcaoResult.getExtraElement();
    }

    private CTeConsultaRecLote gerarDadosConsulta(String string) {
        CTeConsultaRecLote cTeConsultaRecLote = new CTeConsultaRecLote();
        cTeConsultaRecLote.setNumeroRecebimento(string);
        cTeConsultaRecLote.setAmbiente(this.config.getAmbiente());
        cTeConsultaRecLote.setVersao("3.00");
        return cTeConsultaRecLote;
    }
}

