/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.utils;

import com.fincatto.documentofiscal.cte300.classes.nota.CTeNota;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class CTeGeraChave {
    private final CTeNota nota;

    public CTeGeraChave(CTeNota cTeNota) {
        this.nota = cTeNota;
    }

    public String geraCodigoRandomico() {
        Random random = new Random(UUID.randomUUID().timestamp());
        return StringUtils.leftPad((String)String.valueOf(random.nextInt(100000000)), (int)8, (String)"0");
    }

    public String getChaveAcesso() {
        return String.format("%s%s", this.geraChaveAcessoSemDV(), this.getDV());
    }

    public Integer getDV() {
        int n;
        char[] cArray = this.geraChaveAcessoSemDV().toCharArray();
        int[] nArray = new int[]{2, 3, 4, 5, 6, 7, 8, 9};
        int n2 = 0;
        int n3 = 0;
        for (n = cArray.length; n > 0; --n) {
            if (n2 >= nArray.length) {
                n2 = 0;
            }
            int n4 = Integer.parseInt(String.valueOf(cArray[n - 1]));
            int n5 = nArray[n2++];
            n3 += n4 * n5;
        }
        n = 11 - n3 % 11;
        return n == 11 || n == 10 ? 0 : n;
    }

    private String geraChaveAcessoSemDV() {
        if (StringUtils.isBlank((CharSequence)this.nota.getCteNotaInfo().getIdentificacao().getCodigoNumerico())) {
            throw new IllegalStateException("Codigo numerico deve estar presente para gerar a chave de acesso");
        }
        return StringUtils.leftPad((String)this.nota.getCteNotaInfo().getIdentificacao().getCodigoUF().getCodigoIbge(), (int)2, (String)"0") + StringUtils.leftPad((String)DateTimeFormatter.ofPattern("yyMM").format(this.nota.getCteNotaInfo().getIdentificacao().getDataEmissao()), (int)4, (String)"0") + StringUtils.leftPad((String)this.nota.getCteNotaInfo().getEmitente().getCnpj(), (int)14, (String)"0") + StringUtils.leftPad((String)this.nota.getCteNotaInfo().getIdentificacao().getModelo().getCodigo(), (int)2, (String)"0") + StringUtils.leftPad((String)(this.nota.getCteNotaInfo().getIdentificacao().getSerie() + ""), (int)3, (String)"0") + StringUtils.leftPad((String)(this.nota.getCteNotaInfo().getIdentificacao().getNumero() + ""), (int)9, (String)"0") + StringUtils.leftPad((String)this.nota.getCteNotaInfo().getIdentificacao().getTipoEmissao().getCodigo(), (int)1, (String)"0") + StringUtils.leftPad((String)this.nota.getCteNotaInfo().getIdentificacao().getCodigoNumerico(), (int)8, (String)"0");
    }
}

