/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota.consulta;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="consSitCTe")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaConsulta
extends DFBase {
    private static final long serialVersionUID = 402162498360517770L;
    @Attribute(name="versao")
    private String versao;
    @Element(name="tpAmb")
    private DFAmbiente ambiente;
    @Element(name="xServ")
    private String servico;
    @Element(name="chCTe")
    private String chave;

    public void setVersao(BigDecimal bigDecimal) {
        this.versao = BigDecimalValidador.tamanho4Com2CasasDecimais(bigDecimal, "Versao Nota Consulta");
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public void setServico(String string) {
        this.servico = string;
    }

    public void setChave(String string) {
        StringValidador.exatamente44N(string, "Chave de Acesso Nota Consulta");
        this.chave = string;
    }

    public String getVersao() {
        return this.versao;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public String getServico() {
        return this.servico;
    }

    public String getChave() {
        return this.chave;
    }
}

