/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaEndereco;
import com.fincatto.documentofiscal.validadores.StringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="dest")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoDestinatario
extends DFBase {
    private static final long serialVersionUID = 2313824611520451190L;
    @Element(name="CNPJ", required=false)
    private String cnpj = null;
    @Element(name="CPF", required=false)
    private String cpf = null;
    @Element(name="IE", required=false)
    private String inscricaoEstadual = null;
    @Element(name="xNome")
    private String razaoSocial = null;
    @Element(name="fone", required=false)
    private String telefone = null;
    @Element(name="ISUF", required=false)
    private String inscricaoSuframa = null;
    @Element(name="enderDest")
    private CTeNotaEndereco endereco = null;
    @Element(name="email", required=false)
    private String email = null;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        StringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        StringValidador.cpf(string);
        this.cpf = string;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String string) {
        StringValidador.inscricaoEstadual(string);
        this.inscricaoEstadual = string;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String string) {
        StringValidador.tamanho2ate60(string, "Raz\u00e3o Social ou Nome do destinat\u00e1rio");
        this.razaoSocial = string;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String string) {
        StringValidador.telefone(string);
        this.telefone = string;
    }

    public String getInscricaoSuframa() {
        return this.inscricaoSuframa;
    }

    public void setInscricaoSuframa(String string) {
        StringValidador.tamanho8a9N(string, "Inscri\u00e7\u00e3o na SUFRAMA");
        this.inscricaoSuframa = string;
    }

    public CTeNotaEndereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(CTeNotaEndereco cTeNotaEndereco) {
        this.endereco = cTeNotaEndereco;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        StringValidador.tamanho60(string, "Endere\u00e7o de email");
        StringValidador.email(string);
        this.email = string;
    }
}

