/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.CTTipoDirecao;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.ListValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="aquav")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoModalAquaviario
extends DFBase {
    private static final long serialVersionUID = 7558858837552378617L;
    @Element(name="vPrest")
    private String valorPrestacao = null;
    @Element(name="vAFRMM")
    private String valorAdicionalFrete = null;
    @Element(name="xNavio")
    private String identificacaoNavio = null;
    @ElementList(name="balsa", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> balsa = null;
    @Element(name="nViag", required=false)
    private String numeroViagem = null;
    @Element(name="direc")
    private CTTipoDirecao direcao = null;
    @Element(name="irin")
    private String irin = null;
    @ElementList(name="detCont", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> container = null;

    public String getValorPrestacao() {
        return this.valorPrestacao;
    }

    public void setValorPrestacao(BigDecimal bigDecimal) {
        this.valorPrestacao = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Presta\u00e7\u00e3o Base de C\u00e1lculo do AFRMM");
    }

    public String getValorAdicionalFrete() {
        return this.valorAdicionalFrete;
    }

    public void setValorAdicionalFrete(BigDecimal bigDecimal) {
        this.valorAdicionalFrete = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "AFRMM (Adicional de Frete para Renova\u00e7\u00e3o da Marinha Mercante)");
    }

    public String getIdentificacaoNavio() {
        return this.identificacaoNavio;
    }

    public void setIdentificacaoNavio(String string) {
        StringValidador.tamanho60(string, "Identifica\u00e7\u00e3o do Navio");
        this.identificacaoNavio = string;
    }

    public List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> getBalsa() {
        return this.balsa;
    }

    public void setBalsa(List<CTeNotaInfoCTeNormalInfoModalAquaviarioBalsa> list) {
        ListValidador.tamanho3(list, "");
        this.balsa = list;
    }

    public String getNumeroViagem() {
        return this.numeroViagem;
    }

    public void setNumeroViagem(String string) {
        StringValidador.tamanho10(string, "N\u00famero da Viagem");
        this.numeroViagem = string;
    }

    public CTTipoDirecao getDirecao() {
        return this.direcao;
    }

    public void setDirecao(CTTipoDirecao cTTipoDirecao) {
        this.direcao = cTTipoDirecao;
    }

    public String getIrin() {
        return this.irin;
    }

    public void setIrin(String string) {
        StringValidador.tamanho10(string, "Irin do navio");
        this.irin = string;
    }

    public List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> getContainer() {
        return this.container;
    }

    public void setContainer(List<CTeNotaInfoCTeNormalInfoModalAquaviarioConteiner> list) {
        this.container = list;
    }
}

