/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte300.classes.CTModeloNF;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte;
import com.fincatto.documentofiscal.validadores.BigDecimalValidador;
import com.fincatto.documentofiscal.validadores.StringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infNF")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoDocumentosInfoNF
extends DFBase {
    private static final long serialVersionUID = -7538008769125152502L;
    @Element(name="nRoma", required=false)
    private String numeroRomaneio = null;
    @Element(name="nPed", required=false)
    private String numeroPedidoNF = null;
    @Element(name="mod")
    private CTModeloNF modeloNF = null;
    @Element(name="serie")
    private String serie = null;
    @Element(name="nDoc")
    private String numeroDocumento = null;
    @Element(name="dEmi")
    private LocalDate dataEmissao = null;
    @Element(name="vBC")
    private String valorBcICMS = null;
    @Element(name="vICMS")
    private String valorICMS = null;
    @Element(name="vBCST")
    private String valorBcICMSST = null;
    @Element(name="vST")
    private String valorICMSST = null;
    @Element(name="vProd")
    private String valorTotalProdutos = null;
    @Element(name="vNF")
    private String valorTotalNF = null;
    @Element(name="nCFOP")
    private String CFOP = null;
    @Element(name="nPeso", required=false)
    private String valorPesoTotal = null;
    @Element(name="PIN", required=false)
    private String pinSUFRAMA = null;
    @Element(name="dPrev", required=false)
    private LocalDate dataPrevistaEntrega = null;
    @Element(name="infUnidCarga", required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> infoUnidadeCarga = null;
    @Element(name="infUnidTransp", required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> infoUnidadeTransporte = null;

    public String getNumeroRomaneio() {
        return this.numeroRomaneio;
    }

    public void setNumeroRomaneio(String string) {
        StringValidador.tamanho20(string, "N\u00famero do Romaneio da NF");
        this.numeroRomaneio = string;
    }

    public String getNumeroPedidoNF() {
        return this.numeroPedidoNF;
    }

    public void setNumeroPedidoNF(String string) {
        StringValidador.tamanho20(string, "N\u00famero do Pedido da NF");
        this.numeroPedidoNF = string;
    }

    public CTModeloNF getModeloNF() {
        return this.modeloNF;
    }

    public void setModeloNF(CTModeloNF cTModeloNF) {
        this.modeloNF = cTModeloNF;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String string) {
        StringValidador.tamanho3(string, "S\u00e9rie");
        this.serie = string;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String string) {
        StringValidador.tamanho20(string, "N\u00famero");
        this.numeroDocumento = string;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate localDate) {
        this.dataEmissao = localDate;
    }

    public String getValorBcICMS() {
        return this.valorBcICMS;
    }

    public void setValorBcICMS(BigDecimal bigDecimal) {
        this.valorBcICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Base de C\u00e1lculo do ICMS");
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public void setValorICMS(BigDecimal bigDecimal) {
        this.valorICMS = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total do ICMS");
    }

    public String getValorBcICMSST() {
        return this.valorBcICMSST;
    }

    public void setValorBcICMSST(BigDecimal bigDecimal) {
        this.valorBcICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor da Base de C\u00e1lculo do ICMS ST");
    }

    public String getValorICMSST() {
        return this.valorICMSST;
    }

    public void setValorICMSST(BigDecimal bigDecimal) {
        this.valorICMSST = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total do ICMS ST");
    }

    public String getValorTotalProdutos() {
        return this.valorTotalProdutos;
    }

    public void setValorTotalProdutos(BigDecimal bigDecimal) {
        this.valorTotalProdutos = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total dos Produtos");
    }

    public String getValorTotalNF() {
        return this.valorTotalNF;
    }

    public void setValorTotalNF(BigDecimal bigDecimal) {
        this.valorTotalNF = BigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor Total da NF");
    }

    public String getCFOP() {
        return this.CFOP;
    }

    public void setCFOP(String string) {
        StringValidador.exatamente4N(string, "CFOP");
        this.CFOP = string;
    }

    public String getValorPesoTotal() {
        return this.valorPesoTotal;
    }

    public void setValorPesoTotal(BigDecimal bigDecimal) {
        this.valorPesoTotal = BigDecimalValidador.tamanho15Com3CasasDecimais(bigDecimal, "Peso total em Kg");
    }

    public String getPinSUFRAMA() {
        return this.pinSUFRAMA;
    }

    public void setPinSUFRAMA(String string) {
        StringValidador.tamanho2a9N(string, "PIN SUFRAMA");
        this.pinSUFRAMA = string;
    }

    public LocalDate getDataPrevistaEntrega() {
        return this.dataPrevistaEntrega;
    }

    public void setDataPrevistaEntrega(LocalDate localDate) {
        this.dataPrevistaEntrega = localDate;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> getInfoUnidadeCarga() {
        return this.infoUnidadeCarga;
    }

    public void setInfoUnidadeCarga(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> list) {
        this.infoUnidadeCarga = list;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> getInfoUnidadeTransporte() {
        return this.infoUnidadeTransporte;
    }

    public void setInfoUnidadeTransporte(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> list) {
        this.infoUnidadeTransporte = list;
    }
}

