/*
 * Decompiled with CFR 0.152.
 */
package sistema;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sistema.Util;

public class Database {
    boolean conectado = false;
    Connection conexao = null;
    ResultSet result = null;
    Statement st = null;
    private ArrayList<String> msg = new ArrayList();
    private String insert_id;

    public Database(String ipBanco, String usuarioBanco, String senhaBanco, String DATABASE, String porta) {
        this.conectado = this.conectar(ipBanco, usuarioBanco, senhaBanco, DATABASE, porta);
    }

    public Database() {
        this.conectado = this.autoConectar();
    }

    public boolean conectar(String servidor, String usuario, String senha, String database, String porta) {
        String link = "jdbc:mysql://" + servidor + ":" + porta + "/" + database + "?autoReconnect=true&useSSL=false";
        try {
            this.conexao = DriverManager.getConnection(link, usuario, senha);
            return true;
        }
        catch (SQLException ex) {
            Logger.getLogger(Util.class.getName()).log(Level.SEVERE, null, ex);
            this.setMsg("N\u00e3o conectado");
            this.setMsg(ex.getMessage());
            return false;
        }
    }

    public void desconectar() {
        if (this.conectado) {
            this.fecharResultSet(this.result);
            this.fecharStatement(this.st);
            this.fecharConnection(this.conexao);
            this.result = null;
            this.st = null;
            this.conexao = null;
            this.conectado = false;
        }
    }

    private boolean autoConectar() {
        String usuarioBanco = Util.getConfig("usuarioBanco");
        String senhaBanco = Util.getConfig("senhaBanco");
        if (usuarioBanco.equals("")) {
            usuarioBanco = "root";
        }
        if (senhaBanco.equals("SEM_SENHA")) {
            senhaBanco = "tera7iqq";
        }
        return this.conectar(Util.getConfig("ipBanco"), usuarioBanco, senhaBanco, Util.getConfig("DATABASE"), Util.getConfig("porta"));
    }

    public boolean isConectado() {
        return this.conectado;
    }

    public void setMsg(String texto) {
        this.msg.add(texto);
    }

    public String getMsg() {
        String texto = "";
        for (int i = 0; i < this.msg.size(); ++i) {
            texto = texto + this.msg.get(i) + "\n";
        }
        this.msg = new ArrayList();
        return texto;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public void fecharConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
                System.out.println("Desconectou do banco de dados.");
            }
        }
        catch (SQLException ex) {
            System.out.println("Nao conseguiu desconectar do BD.");
        }
    }

    public void fecharStatement(Statement stm) {
        try {
            if (stm != null && !stm.isClosed()) {
                stm.close();
            }
        }
        catch (SQLException ex) {
            System.out.println("Erro ao fechar o procedimento de consulta.");
        }
    }

    public void fecharResultSet(ResultSet resultado) {
        try {
            if (resultado != null && !resultado.isClosed()) {
                resultado.close();
            }
        }
        catch (SQLException ex) {
            System.out.println("Erro ao fechar o resultado da consulta.");
        }
    }

    public boolean queryResult(String query) {
        boolean retorno = true;
        if (!this.conectado) {
            retorno = false;
        } else {
            try {
                this.st = this.conexao.createStatement();
                if (query.substring(0, 6).toLowerCase().equals("update") || query.substring(0, 6).toLowerCase().equals("insert") || query.substring(0, 6).toLowerCase().equals("delete")) {
                    this.st.executeUpdate(query);
                    if (query.substring(0, 6).toLowerCase().equals("insert")) {
                        this.queryResult("select LAST_INSERT_ID() as id");
                        ResultSet result = this.result;
                        ArrayList<HashMap<String, String>> dados = this.resultToHashMap(result, new ArrayList<HashMap<String, String>>(){
                            {
                                this.add(new HashMap(){
                                    {
                                        this.put("campo", "id");
                                    }
                                });
                            }
                        });
                        this.insert_id = dados.get(0).get("id");
                    }
                } else {
                    this.result = this.st.executeQuery(query);
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
                this.setMsg(ex.getMessage());
                retorno = false;
            }
            catch (Exception ex) {
                this.setMsg(ex.getMessage());
                retorno = false;
            }
        }
        return retorno;
    }

    public String insert_id() {
        return this.insert_id;
    }

    public ArrayList<HashMap<String, String>> resultToHashMap(ResultSet result, ArrayList<HashMap<String, String>> campos) {
        ArrayList<HashMap<String, String>> retorno = new ArrayList<HashMap<String, String>>();
        try {
            while (result.next()) {
                HashMap<String, String> linha = new HashMap<String, String>();
                for (int i = 0; i < campos.size(); ++i) {
                    linha.put(campos.get(i).get("campo"), result.getString(campos.get(i).get("campo")));
                }
                retorno.add(linha);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Database.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retorno;
    }

    public String[][] arrayListToString(ArrayList<HashMap<String, String>> dados, ArrayList<HashMap<String, String>> campos) {
        String[][] retorno = new String[dados.size()][campos.size()];
        for (int i = 0; i < dados.size(); ++i) {
            for (int j = 0; j < campos.size(); ++j) {
                retorno[i][j] = dados.get(i).get(campos.get(j).get("campo"));
            }
        }
        return retorno;
    }

    public String[] getColunas(ArrayList<HashMap<String, String>> campos) {
        String[] colunas = new String[campos.size()];
        for (int i = 0; i < campos.size(); ++i) {
            colunas[i] = campos.get(i).get("xcampo").toString();
        }
        return colunas;
    }
}

