/*
 * Decompiled with CFR 0.152.
 */
package sistema;

import br.com.daruma.jna.DUAL;
import io.socket.IOAcknowledge;
import io.socket.IOCallback;
import io.socket.SocketIO;
import io.socket.SocketIOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import nfe.NFe;
import org.json.JSONException;
import org.json.JSONObject;
import sic7.Principal;
import sistema.Argox;
import sistema.GoodWindowsExec;
import sistema.Impressora;
import sistema.Util;

public class Comunicador {
    static SocketIO socket;
    static IOCallback callback;
    private static Thread proc;
    Thread lendo;
    Calendar ultimaImpressao = Calendar.getInstance();
    Calendar delay_ms = Calendar.getInstance();
    Calendar ultimaConexao = Calendar.getInstance();

    public Comunicador() {
        this.ultimaImpressao.set(2000, 1, 1);
        this.ultimaConexao.set(2000, 1, 1);
        callback = new IOCallback(){

            @Override
            public void onMessage(JSONObject json, IOAcknowledge ack) {
                Principal.setStatusNode("Conectado: json " + Util.getNow());
                try {
                    System.out.println("Server said:" + json.toString(2));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onMessage(String data, IOAcknowledge ack) {
                Principal.setStatusNode("Conectado: string " + Util.getNow());
                System.out.println("Server said: " + data);
            }

            @Override
            public void onError(SocketIOException socketIOException) {
                Principal.setStatusNode("Erro: " + Util.getNow() + " " + socketIOException.getMessage());
                Principal.setStatus("Erro: " + Util.getNow() + " " + socketIOException.getMessage());
                Comunicador.this.conectar();
            }

            @Override
            public void onDisconnect() {
                Principal.setStatusNode("Desconectado " + Util.getNow());
                Comunicador.this.conectar();
            }

            @Override
            public void onConnect() {
                Principal.setStatusNode("Conectado " + Util.getNow());
            }

            @Override
            public void on(String event, IOAcknowledge ack, Object ... args) {
                System.out.println("--------");
                System.out.println("event:");
                System.out.println(event);
                System.out.println("args:");
                System.out.println(args);
                System.out.println("--------");
                Principal.setStatusNode("Conectado: on " + Util.getNow());
                if (event.equals("enviaDados")) {
                    Comunicador.this.recebeDados(args[0].toString());
                }
            }
        };
        this.verifica();
    }

    public void conectar() {
        this.conectar(false);
    }

    public void conectar(boolean forcar) {
        Calendar data2 = Calendar.getInstance();
        long diferenca = data2.getTimeInMillis() - this.ultimaConexao.getTimeInMillis();
        if (diferenca > 10000L || forcar) {
            this.ultimaConexao = data2;
            this.desconectar();
            try {
                socket = new SocketIO(Util.getConfig("url"));
                socket.connect(callback);
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void desconectar() {
        if (socket != null) {
            if (socket.isConnected()) {
                socket.disconnect();
            }
            socket = null;
        }
    }

    private void recebeDados(String entrada) {
        try {
            HashMap<String, Object> enviaDados = Util.convertJson(entrada);
            if (enviaDados.get("DATABASE").equals(Util.getConfig("DATABASE"))) {
                Calendar data2 = Calendar.getInstance();
                long diferenca = data2.getTimeInMillis() - this.delay_ms.getTimeInMillis();
                if (diferenca <= (long)Integer.parseInt(Util.getConfig("delay_ms"))) {
                    Principal.setStatus("Chamada duplicada (" + diferenca + ") " + entrada);
                    return;
                }
                this.delay_ms = data2;
                if (enviaDados.get("VERSAO_SIC7").equals(Util.VERSAO_SIC7)) {
                    HashMap<String, Object> dados = Util.convertJson(enviaDados.get("dados").toString());
                    if (dados.get("objeto").equals("lerRetornoTef")) {
                        this.lerRetornoTef();
                    } else if (dados.get("objeto").equals("pagamentotef")) {
                        Util.file_put_contents(dados.get("filename").toString(), dados.get("texto").toString());
                        Principal.setStatus("pagamentotef: " + dados.get("filename").toString() + "\n" + dados.get("texto").toString());
                        this.lerRetornoTef(dados.get("id_impressora").toString());
                    } else if (dados.get("objeto").equals("file_put_contents")) {
                        Util.file_put_contents(dados.get("filename").toString(), dados.get("texto").toString());
                        Principal.setStatus(dados.get("filename").toString() + "\n" + dados.get("texto").toString());
                    } else if (dados.get("objeto").equals("zpl")) {
                        if (Util.getConfig("id_impressora").equals("*") || dados.get("id_impressora").equals(Util.getConfig("id_impressora"))) {
                            System.out.println("id_impressora Recebido: " + dados.get("id_impressora") + " meu id: " + Util.getConfig("id_impressora"));
                            this.imprimir(Util.base64decode(dados.get("texto").toString()));
                        } else {
                            System.out.println("id_impressora diferente Recebido: " + dados.get("id_impressora") + " meu id: " + Util.getConfig("id_impressora"));
                        }
                    } else if (dados.get("objeto").equals("argox") || dados.get("objeto").equals("BPLB")) {
                        if (Util.getConfig("id_impressora").equals("*") || dados.get("id_impressora").equals(Util.getConfig("id_impressora"))) {
                            String impressora = Util.getConfig("impressora");
                            if (dados.get("impressora") != null) {
                                impressora = dados.get("impressora").toString();
                            }
                            this.imprimirArgox(Util.base64decode(dados.get("texto").toString()), impressora);
                        } else {
                            Principal.setStatus("id_impressora diferente Recebido: " + dados.get("id_impressora") + " meu id: " + Util.getConfig("id_impressora"));
                        }
                    } else if (dados.get("objeto").equals("NFSeBematech")) {
                        this.NFSeBematech(Util.getConfig("impressora"), Util.base64decode(dados.get("texto").toString()));
                    } else if (dados.get("objeto").equals("imprimirJava")) {
                        this.imprimir(Util.getConfig("impressora"), Util.base64decode(dados.get("texto").toString()));
                    } else if (dados.get("objeto").equals("imprimirPDF")) {
                        int copias = 1;
                        if (dados.get("copias") != null) {
                            copias = Integer.parseInt(dados.get("copias").toString());
                        }
                        String orientacao = "P";
                        if (dados.get("orientacao") != null) {
                            orientacao = dados.get("orientacao").toString();
                        }
                        if (dados.get("id_impressora") != null && (Util.getConfig("id_impressora").equals("*") || dados.get("id_impressora").toString().equals(Util.getConfig("id_impressora")))) {
                            this.imprimirPDF(Util.getConfig("impressora"), Util.base64decode(dados.get("url").toString()), copias, orientacao);
                        }
                    } else if (dados.get("objeto").equals("imprimir")) {
                        this.imprimir(Util.base64decode(dados.get("texto").toString()));
                    } else if (dados.get("objeto").equals("daruma")) {
                        this.imprimirDaruma(Util.base64decode(dados.get("texto").toString()));
                    } else if (dados.get("objeto").equals("msgPDV")) {
                        if (Util.convertBoolean(dados.get("status").toString())) {
                            Principal.setStatus("MSG " + Util.base64decode(dados.get("msg").toString()));
                        } else {
                            Principal.setStatus("Erro " + Util.base64decode(dados.get("msg").toString()));
                        }
                    } else if (dados.get("objeto").equals("autoSignNFe")) {
                        String PK_nota = dados.get("PK_nota").toString();
                        NFe.autoSignNFe(PK_nota);
                    } else if (dados.get("objeto").equals("autoEnvNFe")) {
                        String PK_nota = dados.get("PK_nota").toString();
                        NFe.autoEnvNFe(PK_nota);
                    } else {
                        Principal.setStatus(entrada);
                    }
                } else {
                    Principal.setStatus("Vers\u00e3o incompat\u00edvel " + enviaDados.get("VERSAO_SIC7") + " != " + Util.VERSAO_SIC7);
                    System.err.println("Vers\u00e3o incompat\u00edvel " + enviaDados.get("VERSAO_SIC7") + " != " + Util.VERSAO_SIC7);
                }
            } else {
                System.err.println("\n" + enviaDados.get("DATABASE") + " != " + Util.getConfig("DATABASE") + "\n");
            }
        }
        catch (Exception e) {
            Principal.setStatus("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void imprimirArgox(String toString, String impressora) {
        Argox argox = new Argox();
        if (!argox.print(toString, impressora)) {
            Principal.setStatus(argox.getMsg());
        } else {
            String msg = "";
            if (argox.isMsg()) {
                msg = msg + argox.getMsg() + "\n";
            }
            msg = msg + "BPLB\n" + toString + "\n";
            Principal.setStatus(msg);
        }
    }

    private void imprimir(String toString) {
        Calendar data2 = Calendar.getInstance();
        long diferenca = data2.getTimeInMillis() - this.ultimaImpressao.getTimeInMillis();
        this.ultimaImpressao = data2;
        Util.deletarArquivo("arquivo.prn");
        Util.file_put_contents("arquivo.prn", toString);
        String command = "";
        command = !Util.getConfig("comandoImpressao").equals("") ? Util.getConfig("comandoImpressao") : (System.getProperty("os.name").equals("Mac OS X") ? "lp -d " + Util.getConfig("impressora") + " arquivo.prn" : "copy /B arquivo.prn \\\\localhost\\" + Util.getConfig("impressora"));
        Principal.setStatus("Comando de Impress\u00e3o: " + command);
        GoodWindowsExec.main(new String[]{command});
        Principal.setStatus(toString);
    }

    private void imprimirDaruma(String texto) {
        System.out.println("imprimirDaruma");
        Calendar data2 = Calendar.getInstance();
        long diferenca = data2.getTimeInMillis() - this.ultimaImpressao.getTimeInMillis();
        System.out.println("imprimirDaruma 2");
        if (diferenca > (long)Integer.parseInt(Util.getConfig("delay_ms"))) {
            Principal.setStatus(Util.getNow() + " imprimirDaruma 2.1");
            System.out.println(texto);
            this.ultimaImpressao = data2;
            System.out.println("imprimirDaruma 4");
            int iRetorno = DUAL.iImprimirTexto((String)texto, (int)0);
            System.out.println("imprimirDaruma 5");
            Principal.setStatus("iRetorno: " + iRetorno + " \n" + texto);
            System.out.println("imprimirDaruma 6");
        } else {
            Principal.setStatus("Impress\u00e3o repetida (" + diferenca + ") \n" + texto);
        }
    }

    private void NFSeBematech(String impressora, String texto) {
        Impressora imp = new Impressora();
        imp.printPdf(Util.getConfig("impressora"), "pdf.pdf", true);
    }

    private void imprimirPDF(String impressora, String url, int copias) {
        this.imprimirPDF(impressora, url, copias, "P");
    }

    private void imprimirPDF(String impressora, String url, int copias, String orientation) {
        Principal.setStatus(url + "\nEnviando para " + impressora + " copias: " + copias);
        String pathname = Util.uniqueName() + "_" + ++Principal.contador + ".pdf";
        Principal.setStatus("Baixando PDF...");
        Util.getURL(url, pathname);
        Principal.setStatus("PDF OK");
        Impressora imp = new Impressora();
        boolean delete = false;
        if (copias == 1) {
            imp.printPdf(impressora, pathname, true, orientation);
        } else {
            for (int i = 0; i < copias; ++i) {
                if (copias == i + 1) {
                    delete = true;
                }
                imp.printPdf(impressora, pathname, delete, orientation);
            }
        }
    }

    private void imprimir(String impressora, String texto) {
        Calendar data2 = Calendar.getInstance();
        long diferenca = data2.getTimeInMillis() - this.ultimaImpressao.getTimeInMillis();
        if (diferenca > (long)Integer.parseInt(Util.getConfig("delay_ms"))) {
            Principal.setStatus("Enviando para " + impressora);
            this.ultimaImpressao = data2;
            Impressora imp = new Impressora();
            imp.detectaImpressoras(impressora);
            ArrayList<String> matches = Util.preg_math_all(texto, "(_hex:[0-9A-Z]*_)");
            for (int i = 0; i < matches.size(); ++i) {
                String a = matches.get(i);
                String dec = Util.hexToDec(a.substring(5, a.length() - 1));
                texto = texto.replace(a, dec);
            }
            imp.imprime(texto);
            Principal.setStatus("Enviando para " + impressora + "\n" + texto);
        } else {
            Principal.setStatus("Impress\u00e3o repetida (" + diferenca + ") " + texto);
        }
    }

    private void verifica() {
        if (proc != null && proc.isAlive()) {
            proc.interrupt();
            proc = null;
        }
        proc = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    if (socket != null && socket.isConnected()) {
                        socket.emit("teste", "teste");
                        socket.send("TESTE");
                    } else {
                        Comunicador.this.conectar();
                    }
                    Comunicador.this.verifica();
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        proc.start();
    }

    public void lerRetornoTef() {
        this.lerRetornoTef("");
    }

    public void lerRetornoTef(final String id_impressora) {
        if (this.lendo != null) {
            Principal.setStatus("STOP loop lerRetornoTef");
            if (this.lendo.isAlive()) {
                this.lendo.interrupt();
                this.lendo = null;
            }
        }
        this.lendo = new Thread(new Runnable(){
            final /* synthetic */ Comunicador this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                String fileTefDialResp = Util.getConfig("fileTefDialResp");
                if (fileTefDialResp.equals("")) {
                    fileTefDialResp = "IntPos.001";
                }
                String filename = Util.getConfig("pathTefDialResp") + fileTefDialResp;
                Principal.setStatus("loop lerRetornoTef " + filename);
                final String tef = Util.lerArquivoTempo(filename, 180);
                Principal.setStatus("lerRetornoTef: " + filename + "\n" + tef);
                if (tef == null) {
                    Principal.setStatus("fim loop lerRetornoTef VAZIO");
                    return;
                }
                boolean repetir = true;
                String[] linhas = tef.split("\r\n");
                for (int i = 0; i < linhas.length; ++i) {
                    if (!linhas[i].substring(0, 7).equals("009-000")) continue;
                    repetir = false;
                    break;
                }
                if (repetir) {
                    Util.deletarArquivo(filename);
                    this.this$0.lerRetornoTef();
                } else {
                    HashMap<Object, String> post = new HashMap<Object, String>(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.put("sistema", Util.getConfig("DATABASE"));
                            this.put("chave", Util.getConfig("SIC7_KEY"));
                            this.put("pacote", "comercial");
                            this.put("class", "Comercial");
                            this.put("metodo", "setTef");
                            this.put("tef", tef);
                        }
                    };
                    if (!id_impressora.equals("")) {
                        post.put("id_impressora", id_impressora);
                    }
                    if (Util.postData(Util.getConfig("urlIntegracao"), post)) {
                        Principal.setStatus("fim loop lerRetornoTef");
                    } else {
                        Principal.setStatus("Erro urlIntegracao");
                    }
                    Util.deletarArquivo(filename);
                }
            }
        });
        this.lendo.start();
    }
}

