/*
 * Decompiled with CFR 0.152.
 */
package producao;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import sistema.Botao;
import sistema.Database;
import sistema.EditText;
import sistema.LabelSIC7;
import sistema.Select;
import sistema.Tabela;
import sistema.Util;

public class Producao
extends JFrame {
    JPanel painelPrincipal;
    DefaultTableModel dataModel;
    Tabela jTabela;
    ArrayList<HashMap<String, String>> dados;
    HashMap<String, String> item;
    JLabel labelPK_producao;
    JLabel labelLote;
    JLabel labelTotalKg;
    JLabel labelGramaturaMedia;
    Select select;
    EditText peso;
    EditText gramatura;
    EditText largura;
    Botao btSalvar;
    Botao btFinalizar;

    public Producao(HashMap<String, String> item) {
        super("Produ\u00e7\u00e3o");
        this.item = item;
        this.criaJanela();
    }

    public void criaJanela() {
        this.painelPrincipal = new JPanel();
        this.painelPrincipal.setLayout(new BorderLayout());
        JPanel painelSuperior = new JPanel(new GridLayout(2, 4));
        this.painelPrincipal.add((Component)painelSuperior, "North");
        painelSuperior.add(new JLabel("Produ\u00e7\u00e3o"));
        painelSuperior.add(new JLabel("Lote"));
        painelSuperior.add(new JLabel("Total Kg"));
        painelSuperior.add(new JLabel("g/m\u00b2 / 2"));
        this.labelPK_producao = new JLabel(this.item.get("PK_producao"));
        this.labelLote = new JLabel(this.item.get("lote"));
        this.labelTotalKg = new JLabel();
        this.labelGramaturaMedia = new JLabel();
        painelSuperior.add(this.labelPK_producao);
        painelSuperior.add(this.labelLote);
        painelSuperior.add(this.labelTotalKg);
        painelSuperior.add(this.labelGramaturaMedia);
        JPanel painelCentral = new JPanel(new BorderLayout());
        this.painelPrincipal.add((Component)painelCentral, "Center");
        JPanel painelSuperior2 = new JPanel(new GridLayout(4, 2));
        painelSuperior2.add(new LabelSIC7("Produto"));
        painelSuperior2.add(new LabelSIC7("Peso"));
        ArrayList<HashMap<String, String>> itensEstoque = this.getItensEstoque();
        this.select = new Select(Select.hashToVector(itensEstoque, "xProd"), itensEstoque, "PK_item");
        painelSuperior2.add(this.select);
        this.peso = new EditText();
        painelSuperior2.add(this.peso);
        painelSuperior2.add(new LabelSIC7("Gramatura g/m\u00b2"));
        painelSuperior2.add(new LabelSIC7("Largura"));
        this.gramatura = new EditText();
        painelSuperior2.add(this.gramatura);
        this.largura = new EditText("190");
        painelSuperior2.add(this.largura);
        painelCentral.add((Component)painelSuperior2, "North");
        JPanel painelCentral2 = new JPanel(new BorderLayout());
        painelCentral.add((Component)painelCentral2, "Center");
        JPanel painelBotao = new JPanel(new GridLayout(1, 2));
        painelCentral2.add((Component)painelBotao, "North");
        this.btSalvar = new Botao("SALVAR");
        painelBotao.add(this.btSalvar);
        this.btSalvar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Producao.this.salvarProducaoSaida();
            }
        });
        this.btFinalizar = new Botao("FINALIZAR");
        painelBotao.add(this.btFinalizar);
        this.btFinalizar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Producao.this.finalizaProducao();
            }
        });
        this.jTabela = new Tabela();
        JScrollPane barraRolagem = new JScrollPane(this.jTabela);
        painelCentral2.add((Component)barraRolagem, "Center");
        this.jTabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int a = Producao.this.jTabela.getSelectedRow();
                Producao.this.excluirProducaoSaida(Producao.this.dados.get(a).get("PK_producao_saida"));
            }
        });
        this.atualizaTabela();
        this.getContentPane().add(this.painelPrincipal);
        this.setDefaultCloseOperation(2);
        this.setExtendedState(6);
        this.setVisible(true);
        this.resetForm();
        this.peso.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Producao.this.gramatura.requestFocus();
                } else if (e.getKeyCode() == 27) {
                    Producao.this.resetForm();
                }
            }
        });
        this.gramatura.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Producao.this.largura.requestFocus();
                } else if (e.getKeyCode() == 27) {
                    Producao.this.resetForm();
                }
            }
        });
        this.largura.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    Producao.this.salvarProducaoSaida();
                } else if (e.getKeyCode() == 27) {
                    Producao.this.resetForm();
                }
            }
        });
    }

    public void resetForm() {
        this.gramatura.setText("");
        this.peso.setText("");
        this.peso.requestFocus();
    }

    public void atualizaTabela() {
        ArrayList campos = new ArrayList(){
            {
                this.add(new HashMap<String, String>(){
                    {
                        this.put("xcampo", "Cont");
                        this.put("campo", "contador");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("xcampo", "Descri\u00e7\u00e3o");
                        this.put("campo", "xProd");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("xcampo", "Peso");
                        this.put("campo", "quantidade");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("xcampo", "Gramatura");
                        this.put("campo", "gramatura");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("xcampo", "Largura");
                        this.put("campo", "altura");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("xcampo", "C\u00f3d");
                        this.put("campo", "PK_producao_saida");
                    }
                });
                this.add(new HashMap<String, String>(){
                    {
                        this.put("xcampo", "Registro");
                        this.put("campo", "dhRegistro");
                    }
                });
            }
        };
        Database database = Util.getDatabase();
        database.queryResult("set @contador=0");
        String query = "select\n@contador := @contador+1 as contador,\nsaida.PK_producao_saida,\nsaida.FK_producao,\nsaida.FK_item,\nsaida.dhRegistro,\nconcat(cast(saida.quantidade as decimal(15, 0)), ' Kg') as quantidade,\nconcat(replace(cast(saida.gramatura as decimal(15, 1)), '.', ','), ' g/m\u00b2') as gramatura,\nconcat(saida.altura, ' cm') as altura,\nitem.xProd,\n0 as custo\nfrom EVE_producao_saida as saida\ninner join EST_item as item on item.PK_item=saida.FK_item\nwhere saida.FK_producao=" + this.item.get("PK_producao").toString() + "\norder by saida.PK_producao_saida asc";
        if (database.queryResult(query)) {
            ResultSet result = database.getResult();
            this.dados = database.resultToHashMap(result, campos);
            this.dataModel = new DefaultTableModel(database.arrayListToString(this.dados, campos), database.getColunas(campos));
            this.jTabela.setModel(this.dataModel);
        } else {
            JOptionPane.showMessageDialog(null, database.getMsg());
        }
        Util.desconectarDatabase();
    }

    private void salvarProducaoSaida() {
        String query;
        Database database = Util.getDatabase();
        if (database.queryResult(query = "select dhFinalizada from EVE_producao where PK_producao=" + this.item.get("PK_producao").toString())) {
            ResultSet result = database.getResult();
            ArrayList<HashMap<String, String>> prod = database.resultToHashMap(result, new ArrayList<HashMap<String, String>>(){
                {
                    this.add(new HashMap(){
                        {
                            this.put("campo", "dhFinalizada");
                        }
                    });
                }
            });
            String FK_producao = this.item.get("PK_producao").toString();
            String FK_itemSQL = this.select.getValue();
            String quantidadeSQL = this.peso.getText().replace(",", ".");
            String gramaturaSQL = this.gramatura.getText().replace(",", ".");
            String alturaSQL = this.largura.getText().replace(",", ".");
            if (prod.get(0).get("dhFinalizada") == null) {
                if (database.queryResult("insert into EVE_producao_saida (FK_producao, FK_item, quantidade, gramatura, altura) values (" + FK_producao + ", " + FK_itemSQL + ", " + quantidadeSQL + ", " + gramaturaSQL + ", " + alturaSQL + ")")) {
                    this.resetForm();
                    this.atualizaTabela();
                    String a = Util.getHTML("http://everest.sic7.com.br/controller/sistema/mobile.controller.php?metodo=imprimirEtiqueta&VERSAO_SIC7=" + Util.VERSAO_SIC7 + "&SIC7_KEY=" + Util.getConfig("SIC7_KEY") + "&PK_producao_saida=" + database.insert_id());
                    System.out.println(a);
                } else {
                    JOptionPane.showMessageDialog(null, database.getMsg());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Produ\u00e7\u00e3o j\u00e1 finalizada");
            }
        } else {
            JOptionPane.showMessageDialog(null, database.getMsg());
        }
        Util.desconectarDatabase();
    }

    private void excluirProducaoSaida(String PK_producao_saida) {
        int reply = JOptionPane.showConfirmDialog(null, "Deseja excluir o registro " + PK_producao_saida, "Excluir", 0);
        if (reply == 0) {
            String query;
            Database database = Util.getDatabase();
            if (database.queryResult(query = "select prod.dhFinalizada from EVE_producao as prod inner join EVE_producao_saida as saida on saida.FK_producao=prod.PK_producao where saida.PK_producao_saida=" + PK_producao_saida)) {
                ResultSet result = database.getResult();
                ArrayList<HashMap<String, String>> prod = database.resultToHashMap(result, new ArrayList<HashMap<String, String>>(){
                    {
                        this.add(new HashMap(){
                            {
                                this.put("campo", "dhFinalizada");
                            }
                        });
                    }
                });
                if (prod.get(0).get("dhFinalizada") == null) {
                    if (database.queryResult("delete from EVE_producao_saida where PK_producao_saida=" + PK_producao_saida)) {
                        this.atualizaTabela();
                    } else {
                        JOptionPane.showMessageDialog(null, database.getMsg());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Produ\u00e7\u00e3o j\u00e1 finalizada");
                }
            } else {
                JOptionPane.showMessageDialog(null, database.getMsg());
            }
        }
        Util.desconectarDatabase();
    }

    private void finalizaProducao() {
        String query;
        Database database = Util.getDatabase();
        if (database.queryResult(query = "select dhFinalizada from EVE_producao where PK_producao=" + this.item.get("PK_producao").toString())) {
            ResultSet result = database.getResult();
            ArrayList<HashMap<String, String>> prod = database.resultToHashMap(result, new ArrayList<HashMap<String, String>>(){
                {
                    this.add(new HashMap(){
                        {
                            this.put("campo", "dhFinalizada");
                        }
                    });
                }
            });
            if (prod.get(0).get("dhFinalizada") == null) {
                database.queryResult("update EVE_producao set dhFinalizada=now() where PK_producao=" + this.item.get("PK_producao").toString());
                JOptionPane.showMessageDialog(null, "Produ\u00e7\u00e3o finalizada");
            } else {
                JOptionPane.showMessageDialog(null, "Produ\u00e7\u00e3o j\u00e1 finalizada");
            }
        } else {
            JOptionPane.showMessageDialog(null, database.getMsg());
        }
        Util.desconectarDatabase();
    }

    private ArrayList<HashMap<String, String>> getItensEstoque() {
        String query;
        ArrayList<HashMap<String, String>> retorno = new ArrayList<HashMap<String, String>>();
        Database database = Util.getDatabase();
        if (database.queryResult(query = "select PK_item, xProd from EST_item where produto is not null order by xProd")) {
            ResultSet result = database.getResult();
            ArrayList<HashMap<String, String>> campos = new ArrayList<HashMap<String, String>>(){
                {
                    this.add(new HashMap(){
                        {
                            this.put("campo", "PK_item");
                        }
                    });
                    this.add(new HashMap(){
                        {
                            this.put("campo", "xProd");
                        }
                    });
                }
            };
            retorno = database.resultToHashMap(result, campos);
        } else {
            JOptionPane.showMessageDialog(null, database.getMsg());
        }
        Util.desconectarDatabase();
        return retorno;
    }
}

