/*
 * Decompiled with CFR 0.152.
 */
package nfe;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;

public class SIC7Certificado {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static X509Certificate certificado;
    public static KeyStore.PrivateKeyEntry pkEntry;
    public static PrivateKey privateKey;
    public static KeyInfo keyInfo;
    public static String senha;

    public static void get(String getAlias) {
        try {
            KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
            keyStore.load(null, null);
            Enumeration<String> al = keyStore.aliases();
            while (al.hasMoreElements()) {
                String alias = al.nextElement();
                SIC7Certificado.info("--------------------------------------------------------");
                if (keyStore.containsAlias(alias)) {
                    SIC7Certificado.info("Emitido para........: " + alias);
                    X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                    if (alias.equals(getAlias)) {
                        certificado = cert;
                        pkEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(senha.toCharArray()));
                        privateKey = pkEntry.getPrivateKey();
                        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM");
                        KeyInfoFactory keyInfoFactory = signatureFactory.getKeyInfoFactory();
                        ArrayList<X509Certificate> x509Content = new ArrayList<X509Certificate>();
                        x509Content.add(cert);
                        X509Data x509Data = keyInfoFactory.newX509Data(x509Content);
                        keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
                    }
                    SIC7Certificado.info("SubjectDN...........: " + cert.getSubjectDN().toString());
                    SIC7Certificado.info("Version.............: " + cert.getVersion());
                    SIC7Certificado.info("SerialNumber........: " + cert.getSerialNumber());
                    SIC7Certificado.info("SigAlgName..........: " + cert.getSigAlgName());
                    SIC7Certificado.info("V\u00e1lido a partir de..: " + dateFormat.format(cert.getNotBefore()));
                    SIC7Certificado.info("V\u00e1lido at\u00e9..........: " + dateFormat.format(cert.getNotAfter()));
                    continue;
                }
                SIC7Certificado.info("Alias doesn't exists : " + alias);
            }
        }
        catch (Exception e) {
            SIC7Certificado.error(e.toString());
        }
    }

    private static void info(String log) {
        System.out.println("INFO: " + log);
    }

    private static void error(String log) {
        System.out.println("ERROR: " + log);
    }

    static {
        pkEntry = null;
        senha = "1234";
    }
}

