/*
 * Decompiled with CFR 0.152.
 */
package nfe;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class NFeConfigSIC7
extends NFeConfig {
    private KeyStore keyStoreCertificado = null;
    private KeyStore keyStoreCadeia = null;

    public DFUnidadeFederativa getCUF() {
        return DFUnidadeFederativa.PE;
    }

    public String getCertificadoSenha() {
        return "senha_certificado";
    }

    public String getCadeiaCertificadosSenha() {
        return "senha_cadeia";
    }

    public KeyStore getCertificadoKeyStore() throws KeyStoreException {
        if (this.keyStoreCertificado == null) {
            this.keyStoreCertificado = KeyStore.getInstance("PKCS12");
            try (FileInputStream certificadoStream = new FileInputStream("/tmp/certificado.pfx");){
                this.keyStoreCertificado.load(certificadoStream, this.getCertificadoSenha().toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                this.keyStoreCadeia = null;
                throw new KeyStoreException("Nao foi possibel montar o KeyStore com a cadeia de certificados", e);
            }
        }
        return this.keyStoreCertificado;
    }

    public KeyStore getCadeiaCertificadosKeyStore() throws KeyStoreException {
        if (this.keyStoreCadeia == null) {
            this.keyStoreCadeia = KeyStore.getInstance("JKS");
            try (FileInputStream cadeia = new FileInputStream("/tmp/cadeia.jks");){
                this.keyStoreCadeia.load(cadeia, this.getCadeiaCertificadosSenha().toCharArray());
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                this.keyStoreCadeia = null;
                throw new KeyStoreException("Nao foi possibel montar o KeyStore com o certificado", e);
            }
        }
        return this.keyStoreCadeia;
    }
}

