/*
 * Decompiled with CFR 0.152.
 */
package nfe;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.statusservico.consulta.NFStatusServicoConsultaRetorno;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nfe.NFeConfigSIC7;
import nfe.SIC7Certificado;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sic7.Principal;
import sistema.Util;
import sistema.cURL;

public class NFe {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static ArrayList<HashMap<String, Object>> certificados;
    public static String notaAssinada;

    public static void getDadosCertificado() {
        certificados = new ArrayList();
        try {
            KeyStore keyStore = KeyStore.getInstance("Windows-MY", "SunMSCAPI");
            keyStore.load(null, null);
            Enumeration<String> al = keyStore.aliases();
            while (al.hasMoreElements()) {
                String alias = al.nextElement();
                if (keyStore.containsAlias(alias)) {
                    X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                    HashMap<String, Object> certificado = new HashMap<String, Object>();
                    certificado.put("nome", alias);
                    certificado.put("subjectDN", cert.getSubjectDN().toString());
                    certificado.put("version", cert.getVersion());
                    certificado.put("serialNumber", cert.getSerialNumber());
                    certificado.put("sigAlgName", cert.getSigAlgName());
                    certificado.put("dtEmissao", dateFormat.format(cert.getNotBefore()));
                    certificado.put("dtValidade", dateFormat.format(cert.getNotAfter()));
                    certificados.add(certificado);
                    continue;
                }
                System.out.println("Alias doesn't exists : " + alias);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static void autoSignNFe(String PK_nota) {
        Principal.setStatus("Assinar nota " + PK_nota);
        if (Util.getDatabase().queryResult("select xml from NFE_nota where PK_nota=" + PK_nota)) {
            ArrayList campos = new ArrayList(){
                {
                    this.add(new HashMap<Object, Object>(){
                        {
                            this.put("campo", "xml");
                        }
                    });
                }
            };
            ArrayList<HashMap<String, String>> dados = Util.getDatabase().resultToHashMap(Util.getDatabase().getResult(), campos);
            String xml = dados.get(0).get("xml");
            try {
                String xmlAssinado = NFe.assinarXML(xml);
                String query = "";
                query = "update NFE_nota set xml='" + xmlAssinado + "', mensagem='', stat='" + notaAssinada + "' where PK_nota=" + PK_nota;
                if (Util.getDatabase().queryResult(query)) {
                    // empty if block
                }
                NFe.atualizaLista();
                cURL curl = new cURL();
                String url = "";
                String sistema = "ipvc";
                url = url + "http://sic7.com.br/sic7_4/controller/controller.php?sistema=" + sistema + "pacote=fiscal&class=NFeSIC7&metodo=setXMLAssinadoA3&PK_nota=" + PK_nota;
                String page = curl.exec(url);
                Principal.setStatus("cURL " + page);
            }
            catch (Exception ex) {
                Principal.setStatus("Erro assinatura: " + ex.getMessage());
                Logger.getLogger(NFe.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Principal.setStatus("Erro query nota " + PK_nota);
        }
        Util.desconectarDatabase();
    }

    public static void statusNFe() {
        Principal.setStatus("Consultar status NFe...");
        try {
            NFeConfigSIC7 config = new NFeConfigSIC7();
            NFStatusServicoConsultaRetorno retorno = new WSFacade((NFeConfig)config).consultaStatus(DFUnidadeFederativa.PE, DFModelo.NFE);
            System.out.println(retorno.getStatus());
            System.out.println(retorno.getMotivo());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Principal.setStatus("Erro: " + ex.getMessage());
            Logger.getLogger(NFe.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void autoEnvNFe(String PK_nota) {
        Principal.setStatus("Enviar nota " + PK_nota);
        if (Util.getDatabase().queryResult("select xml from NFE_nota where PK_nota=" + PK_nota)) {
            ArrayList campos = new ArrayList(){
                {
                    this.add(new HashMap<Object, Object>(){
                        {
                            this.put("campo", "xml");
                        }
                    });
                }
            };
            ArrayList<HashMap<String, String>> dados = Util.getDatabase().resultToHashMap(Util.getDatabase().getResult(), campos);
            String xml = dados.get(0).get("xml");
            try {
                cURL curl = new cURL();
                String url = "https://nfe.sefaz.pe.gov.br/nfe-service/services/NFeStatusServico4";
                curl.exec(url);
            }
            catch (Exception ex) {
                Principal.setStatus("Erro assinatura: " + ex.getMessage());
                Logger.getLogger(NFe.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Principal.setStatus("Erro query nota " + PK_nota);
        }
        Util.desconectarDatabase();
    }

    private static void atualizaLista() {
        cURL curl = new cURL();
        curl.exec("http://cloud.sic7.com.br:3000/callback?PK_usuarioDestino=TODOS&DATABASE=sic7_manancial&callback=atualizaListaNotas()");
    }

    public static String assinarXML(String xml) throws Exception {
        Document documentXML = Util.xmlToDocument(xml);
        Node nodeAssinar = null;
        int index = 0;
        NodeList listaNodes = documentXML.getDocumentElement().getElementsByTagName("infNFe");
        if (index < listaNodes.getLength()) {
            nodeAssinar = listaNodes.item(index);
        }
        String alias = "ALDIRENE PAIVA DOS SANTOS";
        SIC7Certificado.get(alias);
        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = NFe.novaListaCriptografias(signatureFactory);
        PrivateKey privateKey = SIC7Certificado.privateKey;
        KeyInfo keyInfo = SIC7Certificado.keyInfo;
        Element element = (Element)nodeAssinar;
        String idReference = element.getAttribute("Id");
        if (idReference == null || idReference.equals("")) {
            idReference = "";
        } else {
            element.setIdAttribute("Id", true);
            idReference = "#" + idReference;
        }
        Reference reference = signatureFactory.newReference(idReference, signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), transformList, null, null);
        CanonicalizationMethod canonicalizationMethod = signatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        SignatureMethod signatureMethod = signatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        SignedInfo signedInfo = signatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, Collections.singletonList(reference));
        XMLSignature signature = signatureFactory.newXMLSignature(signedInfo, keyInfo);
        DOMSignContext domSignContext = new DOMSignContext(privateKey, nodeAssinar.getParentNode());
        signature.sign(domSignContext);
        String xmlAssinado = NFe.outputXML(documentXML);
        return xmlAssinado;
    }

    private static String outputXML(Document doc) throws TransformerException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    public static ArrayList<Transform> novaListaCriptografias(XMLSignatureFactory signatureFactory) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec transformParameterSpec = null;
        transformList.add(signatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", transformParameterSpec));
        transformList.add(signatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", transformParameterSpec));
        return transformList;
    }

    static {
        notaAssinada = "6";
    }
}

