/*
 * Decompiled with CFR 0.152.
 */
import java.awt.TextArea;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.CommPortIdentifier;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class SerialConnection
implements SerialPortEventListener,
CommPortOwnershipListener {
    private SerialDemo parent;
    private TextArea messageAreaOut;
    private TextArea messageAreaIn;
    private SerialParameters parameters;
    private OutputStream os;
    private InputStream is;
    private KeyHandler keyHandler;
    private CommPortIdentifier portId;
    private SerialPort sPort;
    private boolean open;

    public SerialConnection(SerialDemo parent, SerialParameters parameters, TextArea messageAreaOut, TextArea messageAreaIn) {
        this.parent = parent;
        this.parameters = parameters;
        this.messageAreaOut = messageAreaOut;
        this.messageAreaIn = messageAreaIn;
        this.open = false;
    }

    public void openConnection() throws SerialConnectionException {
        try {
            this.portId = CommPortIdentifier.getPortIdentifier(this.parameters.getPortName());
        }
        catch (NoSuchPortException e) {
            throw new SerialConnectionException(e.getMessage());
        }
        try {
            this.sPort = (SerialPort)this.portId.open("SerialDemo", 30000);
        }
        catch (PortInUseException e) {
            throw new SerialConnectionException(e.getMessage());
        }
        try {
            this.setConnectionParameters();
        }
        catch (SerialConnectionException e) {
            this.sPort.close();
            throw e;
        }
        try {
            this.os = this.sPort.getOutputStream();
            this.is = this.sPort.getInputStream();
        }
        catch (IOException e) {
            this.sPort.close();
            throw new SerialConnectionException("Error opening i/o streams");
        }
        this.keyHandler = new KeyHandler(this.os);
        this.messageAreaOut.addKeyListener(this.keyHandler);
        try {
            this.sPort.addEventListener(this);
        }
        catch (TooManyListenersException e) {
            this.sPort.close();
            throw new SerialConnectionException("too many listeners added");
        }
        this.sPort.notifyOnDataAvailable(true);
        this.sPort.notifyOnBreakInterrupt(true);
        try {
            this.sPort.enableReceiveTimeout(30);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.portId.addPortOwnershipListener(this);
        this.open = true;
    }

    public void setConnectionParameters() throws SerialConnectionException {
        int oldBaudRate = this.sPort.getBaudRate();
        int oldDatabits = this.sPort.getDataBits();
        int oldStopbits = this.sPort.getStopBits();
        int oldParity = this.sPort.getParity();
        int oldFlowControl = this.sPort.getFlowControlMode();
        try {
            this.sPort.setSerialPortParams(this.parameters.getBaudRate(), this.parameters.getDatabits(), this.parameters.getStopbits(), this.parameters.getParity());
        }
        catch (UnsupportedCommOperationException e) {
            this.parameters.setBaudRate(oldBaudRate);
            this.parameters.setDatabits(oldDatabits);
            this.parameters.setStopbits(oldStopbits);
            this.parameters.setParity(oldParity);
            throw new SerialConnectionException("Unsupported parameter");
        }
        try {
            this.sPort.setFlowControlMode(this.parameters.getFlowControlIn() | this.parameters.getFlowControlOut());
        }
        catch (UnsupportedCommOperationException e) {
            throw new SerialConnectionException("Unsupported flow control");
        }
    }

    public void closeConnection() {
        if (!this.open) {
            return;
        }
        this.messageAreaOut.removeKeyListener(this.keyHandler);
        if (this.sPort != null) {
            try {
                this.os.close();
                this.is.close();
            }
            catch (IOException e) {
                System.err.println(e);
            }
            this.sPort.close();
            this.portId.removePortOwnershipListener(this);
        }
        this.open = false;
    }

    public void sendBreak() {
        this.sPort.sendBreak(1000);
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void serialEvent(SerialPortEvent e) {
        StringBuffer inputBuffer = new StringBuffer();
        int newData = 0;
        switch (e.getEventType()) {
            case 1: {
                while (newData != -1) {
                    try {
                        newData = this.is.read();
                        if (newData == -1) break;
                        if ('\r' == (char)newData) {
                            inputBuffer.append('\n');
                            continue;
                        }
                        inputBuffer.append((char)newData);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                        return;
                    }
                }
                this.messageAreaIn.append(new String(inputBuffer));
                break;
            }
            case 10: {
                this.messageAreaIn.append("\n--- BREAK RECEIVED ---\n");
            }
        }
    }

    @Override
    public void ownershipChange(int type) {
        if (type == 3) {
            PortRequestedDialog portRequestedDialog = new PortRequestedDialog(this.parent);
        }
    }

    class KeyHandler
    extends KeyAdapter {
        OutputStream os;

        public KeyHandler(OutputStream os) {
            this.os = os;
        }

        @Override
        public void keyTyped(KeyEvent evt) {
            char newCharacter = evt.getKeyChar();
            try {
                this.os.write(newCharacter);
            }
            catch (IOException e) {
                System.err.println("OutputStream write error: " + e);
            }
        }
    }
}

