/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.ssh;

import java.io.IOException;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class PrefsHelper {
    private static Logger logger = Logger.getLogger(PrefsHelper.class.getName());

    static void clearNode(Preferences node) {
        try {
            logger.finer("Clear wrong data from preferences node " + node.name());
            node.clear();
            node.sync();
        }
        catch (BackingStoreException e) {
            logger.warning("Cannot clear/sync preferences node '" + node.name() + "': " + e.getMessage());
        }
    }

    static void addRecordTo(Preferences node, String key, String record) throws IOException {
        String out = PrefsHelper.getStringFrom(node, key);
        if (out.length() > 0 && !out.endsWith("\n")) {
            out = out + '\n';
        }
        out = out + record + '\n';
        PrefsHelper.clearNode(node);
        PrefsHelper.update(node, key, out);
    }

    private static void update(Preferences node, String key, String value) {
        int length = value.length();
        if (length <= 8192) {
            node.put(key, value);
        } else {
            int idx = 0;
            int cnt = 1;
            while (idx < length) {
                if (length - idx > 8192) {
                    node.put(key + "." + cnt, value.substring(idx, idx + 8192));
                    idx += 8192;
                } else {
                    node.put(key + "." + cnt, value.substring(idx));
                    idx = length;
                }
                ++cnt;
            }
        }
        try {
            node.sync();
        }
        catch (BackingStoreException e) {
            logger.warning("Cannot sync preferences node '" + node.name() + "': " + e.getMessage());
        }
    }

    static String getStringFrom(Preferences sshNode, String key) {
        StringBuilder out = new StringBuilder();
        try {
            String partKey;
            String part;
            String str = sshNode.get(key, "");
            out.append(str);
            int cnt = 1;
            while ((part = sshNode.get(partKey = key + "." + cnt, "")).length() > 0) {
                out.append(part);
                ++cnt;
            }
        }
        catch (Exception r) {
            logger.warning("Wrong data at '" + sshNode.absolutePath() + "#" + key + "' prefs: " + r.getMessage());
            PrefsHelper.clearNode(sshNode);
        }
        logger.finer("KnownHosts: \n" + out.toString());
        return out.toString();
    }
}

