/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.client.KeyEventMessage;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.settings.UiSettings;
import com.glavsoft.viewer.swing.ConnectionPresenter;
import com.glavsoft.viewer.swing.ModifierButtonEventListener;
import com.glavsoft.viewer.swing.MouseEnteredListener;
import com.glavsoft.viewer.swing.Surface;
import com.glavsoft.viewer.swing.Utils;
import com.glavsoft.viewer.swing.ViewerEventsListener;
import com.glavsoft.viewer.swing.gui.OptionsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class SwingViewerWindow
implements IChangeSettingsListener,
MouseEnteredListener {
    public static final int FS_SCROLLING_ACTIVE_BORDER = 20;
    private JToggleButton zoomFitButton;
    private JToggleButton zoomFullScreenButton;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JButton zoomAsIsButton;
    private JScrollPane scroller;
    private JFrame frame;
    private boolean forceResizable = true;
    private ButtonsBar buttonsBar;
    private Surface surface;
    private boolean isSeparateFrame;
    private ViewerEventsListener viewerEventsListener;
    private final String appName;
    private String connectionString;
    private ConnectionPresenter presenter;
    private Rectangle oldContainerBounds;
    private volatile boolean isFullScreen;
    private Border oldScrollerBorder;
    private JLayeredPane lpane;
    private EmptyButtonsBarMouseAdapter buttonsBarMouseAdapter;
    private String remoteDesktopName;
    private ProtocolSettings rfbSettings;
    private UiSettings uiSettings;
    private Protocol workingProtocol;
    private boolean isZoomToFitSelected;
    private List<JComponent> kbdButtons;
    private Container container;
    private static Logger logger = Logger.getLogger(SwingViewerWindow.class.getName());

    public SwingViewerWindow(Protocol workingProtocol, ProtocolSettings rfbSettings, UiSettings uiSettings, Surface surface, boolean isSeparateFrame, boolean isApplet, ViewerEventsListener viewerEventsListener, String appName, String connectionString, ConnectionPresenter presenter, Container externalContainer) {
        this.workingProtocol = workingProtocol;
        this.rfbSettings = rfbSettings;
        this.uiSettings = uiSettings;
        this.surface = surface;
        this.isSeparateFrame = isSeparateFrame;
        this.viewerEventsListener = viewerEventsListener;
        this.appName = appName;
        this.connectionString = connectionString;
        this.presenter = presenter;
        this.createContainer(surface, externalContainer);
        if (uiSettings.showControls) {
            this.createButtonsPanel(workingProtocol, isSeparateFrame ? this.frame : externalContainer, isApplet);
            if (isSeparateFrame) {
                this.registerResizeListener(this.frame);
            }
            this.updateZoomButtonsState();
        }
        if (uiSettings.isFullScreen()) {
            this.switchOnFullscreenMode();
        }
        this.setSurfaceToHandleKbdFocus();
    }

    private void createContainer(final Surface surface, Container externalContainer) {
        this.lpane = new JLayeredPane(){

            @Override
            public Dimension getSize() {
                return surface.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return surface.getPreferredSize();
            }
        };
        this.lpane.setPreferredSize(surface.getPreferredSize());
        this.lpane.add(surface, JLayeredPane.DEFAULT_LAYER, 0);
        this.scroller = new JScrollPane();
        this.scroller.getViewport().setBackground(Color.DARK_GRAY);
        this.scroller.setViewportView(this.lpane);
        if (this.isSeparateFrame) {
            this.frame = new JFrame();
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    super.windowClosing(windowEvent);
                    SwingViewerWindow.this.fireCloseApp();
                }
            });
            this.frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            Utils.setApplicationIconsForWindow(this.frame);
            this.frame.setLayout(new BorderLayout(0, 0));
            this.frame.add((Component)this.scroller, "Center");
            this.lpane.setSize(surface.getPreferredSize());
            this.internalPack(null);
            this.container = this.frame;
            this.fireContainerCompleted();
        } else {
            if (null == externalContainer) {
                throw new IllegalArgumentException("External Container is null");
            }
            externalContainer.setLayout(new BorderLayout(0, 0));
            externalContainer.add((Component)this.scroller, "Center");
            this.container = externalContainer;
            this.fireContainerCompleted();
        }
    }

    private void fireContainerCompleted() {
        if (this.viewerEventsListener != null) {
            this.viewerEventsListener.onViewerComponentContainerBuilt(this);
        }
    }

    public void pack() {
        Dimension oldSize = this.lpane.getSize();
        this.lpane.setSize(this.surface.getPreferredSize());
        if (this.isSeparateFrame && !this.isZoomToFitSelected()) {
            this.internalPack(oldSize);
        }
        if (this.buttonsBar != null) {
            this.updateZoomButtonsState();
        }
        this.updateWindowTitle();
    }

    public boolean isZoomToFitSelected() {
        return this.isZoomToFitSelected;
    }

    public void setZoomToFitSelected(boolean zoomToFitSelected) {
        this.isZoomToFitSelected = zoomToFitSelected;
    }

    public void setRemoteDesktopName(String name) {
        this.remoteDesktopName = name;
        this.updateWindowTitle();
    }

    private void updateWindowTitle() {
        if (this.isSeparateFrame) {
            this.frame.setTitle(this.remoteDesktopName + " [zoom: " + this.uiSettings.getScalePercentFormatted() + "%]");
        }
    }

    private void internalPack(Dimension outerPanelOldSize) {
        Rectangle workareaRectangle = this.getWorkareaRectangle();
        if (workareaRectangle.equals(this.frame.getBounds())) {
            this.forceResizable = true;
        }
        boolean isHScrollBar = this.scroller.getHorizontalScrollBar().isShowing() && !this.forceResizable;
        boolean isVScrollBar = this.scroller.getVerticalScrollBar().isShowing() && !this.forceResizable;
        boolean isWidthChangeable = true;
        boolean isHeightChangeable = true;
        if (outerPanelOldSize != null && this.surface.oldSize != null) {
            isWidthChangeable = this.forceResizable || outerPanelOldSize.width == this.surface.oldSize.width && !isHScrollBar;
            isHeightChangeable = this.forceResizable || outerPanelOldSize.height == this.surface.oldSize.height && !isVScrollBar;
        }
        this.forceResizable = false;
        this.frame.validate();
        Insets containerInsets = this.frame.getInsets();
        Dimension preferredSize = this.frame.getPreferredSize();
        Rectangle preferredRectangle = new Rectangle(this.frame.getLocation(), preferredSize);
        if (null == outerPanelOldSize && workareaRectangle.contains(preferredRectangle)) {
            this.frame.pack();
        } else {
            Dimension minDimension = new Dimension(containerInsets.left + containerInsets.right, containerInsets.top + containerInsets.bottom);
            if (this.buttonsBar != null && this.buttonsBar.isVisible) {
                minDimension.width += this.buttonsBar.getWidth();
                minDimension.height += this.buttonsBar.getHeight();
            }
            Dimension dim = new Dimension(preferredSize);
            Point location = this.frame.getLocation();
            if (!isWidthChangeable) {
                dim.width = this.frame.getWidth();
            } else {
                int w;
                int dx;
                if (isVScrollBar) {
                    dim.width += this.scroller.getVerticalScrollBar().getWidth();
                }
                if (dim.width < minDimension.width) {
                    dim.width = minDimension.width;
                }
                if ((dx = location.x - workareaRectangle.x) < 0) {
                    dx = 0;
                    location.x = workareaRectangle.x;
                }
                if ((w = workareaRectangle.width - dx) < dim.width) {
                    int dw = dim.width - w;
                    if (dw < dx) {
                        location.x -= dw;
                    } else {
                        dim.width = workareaRectangle.width;
                        location.x = workareaRectangle.x;
                    }
                }
            }
            if (!isHeightChangeable) {
                dim.height = this.frame.getHeight();
            } else {
                int h;
                int dy;
                if (isHScrollBar) {
                    dim.height += this.scroller.getHorizontalScrollBar().getHeight();
                }
                if (dim.height < minDimension.height) {
                    dim.height = minDimension.height;
                }
                if ((dy = location.y - workareaRectangle.y) < 0) {
                    dy = 0;
                    location.y = workareaRectangle.y;
                }
                if ((h = workareaRectangle.height - dy) < dim.height) {
                    int dh = dim.height - h;
                    if (dh < dy) {
                        location.y -= dh;
                    } else {
                        dim.height = workareaRectangle.height;
                        location.y = workareaRectangle.y;
                    }
                }
            }
            if (!location.equals(this.frame.getLocation())) {
                this.frame.setLocation(location);
            }
            if (!this.isFullScreen) {
                this.frame.setSize(dim);
            }
        }
        this.scroller.revalidate();
    }

    private Rectangle getWorkareaRectangle() {
        GraphicsConfiguration graphicsConfiguration = this.frame.getGraphicsConfiguration();
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        return screenBounds;
    }

    void addZoomButtons() {
        this.buttonsBar.createStrut();
        this.zoomOutButton = this.buttonsBar.createButton("zoom-out", "Zoom Out", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.zoomFitButton.setSelected(false);
                SwingViewerWindow.this.uiSettings.zoomOut();
            }
        });
        this.zoomInButton = this.buttonsBar.createButton("zoom-in", "Zoom In", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.zoomFitButton.setSelected(false);
                SwingViewerWindow.this.uiSettings.zoomIn();
            }
        });
        this.zoomAsIsButton = this.buttonsBar.createButton("zoom-100", "Zoom 100%", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.zoomFitButton.setSelected(false);
                SwingViewerWindow.this.forceResizable = false;
                SwingViewerWindow.this.uiSettings.zoomAsIs();
            }
        });
        this.zoomFitButton = this.buttonsBar.createToggleButton("zoom-fit", "Zoom to Fit Window", new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SwingViewerWindow.this.setZoomToFitSelected(true);
                    SwingViewerWindow.this.forceResizable = true;
                    SwingViewerWindow.this.zoomToFit();
                    SwingViewerWindow.this.updateZoomButtonsState();
                } else {
                    SwingViewerWindow.this.setZoomToFitSelected(false);
                }
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.zoomFullScreenButton = this.buttonsBar.createToggleButton("zoom-fullscreen", "Full Screen", new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SwingViewerWindow.this.updateZoomButtonsState();
                if (e.getStateChange() == 1) {
                    SwingViewerWindow.this.uiSettings.setFullScreen(SwingViewerWindow.this.switchOnFullscreenMode());
                } else {
                    SwingViewerWindow.this.switchOffFullscreenMode();
                    SwingViewerWindow.this.uiSettings.setFullScreen(false);
                }
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        });
        if (!this.isSeparateFrame) {
            this.zoomFullScreenButton.setEnabled(false);
            this.zoomFitButton.setEnabled(false);
        }
    }

    protected void setSurfaceToHandleKbdFocus() {
        if (this.surface != null && !this.surface.requestFocusInWindow()) {
            this.surface.requestFocus();
        }
    }

    boolean switchOnFullscreenMode() {
        this.zoomFullScreenButton.setSelected(true);
        this.oldContainerBounds = this.frame.getBounds();
        this.buttonsBar.setNoFullScreenGroupVisible(false);
        this.setButtonsBarVisible(false);
        this.forceResizable = true;
        this.frame.dispose();
        this.frame.setUndecorated(true);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
        try {
            this.frame.getGraphicsConfiguration().getDevice().setFullScreenWindow(this.frame);
            this.isFullScreen = true;
            this.scroller.setVerticalScrollBarPolicy(21);
            this.scroller.setHorizontalScrollBarPolicy(31);
            this.oldScrollerBorder = this.scroller.getBorder();
            this.scroller.setBorder(new EmptyBorder(0, 0, 0, 0));
            new FullscreenBorderDetectionThread(this.frame).start();
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).info("Cannot switch into FullScreen mode: " + ex.getMessage());
            return false;
        }
        return true;
    }

    private void switchOffFullscreenMode() {
        if (this.isFullScreen) {
            this.zoomFullScreenButton.setSelected(false);
            this.isFullScreen = false;
            this.buttonsBar.setNoFullScreenGroupVisible(true);
            this.setButtonsBarVisible(true);
            try {
                this.frame.dispose();
                this.frame.setUndecorated(false);
                this.frame.setResizable(true);
                this.frame.getGraphicsConfiguration().getDevice().setFullScreenWindow(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.scroller.setVerticalScrollBarPolicy(20);
            this.scroller.setHorizontalScrollBarPolicy(30);
            this.scroller.setBorder(this.oldScrollerBorder);
            this.frame.setBounds(this.oldContainerBounds);
            this.frame.setVisible(true);
            this.pack();
        }
    }

    private void zoomToFit() {
        Dimension scrollerSize = this.scroller.getSize();
        Insets scrollerInsets = this.scroller.getInsets();
        this.uiSettings.zoomToFit(scrollerSize.width - scrollerInsets.left - scrollerInsets.right, scrollerSize.height - scrollerInsets.top - scrollerInsets.bottom + (this.isFullScreen ? this.buttonsBar.getHeight() : 0), this.workingProtocol.getFbWidth(), this.workingProtocol.getFbHeight());
    }

    void registerResizeListener(Container container) {
        container.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SwingViewerWindow.this.isZoomToFitSelected()) {
                    SwingViewerWindow.this.zoomToFit();
                    SwingViewerWindow.this.updateZoomButtonsState();
                    SwingViewerWindow.this.updateWindowTitle();
                    SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
                }
            }
        });
    }

    void updateZoomButtonsState() {
        this.zoomOutButton.setEnabled(this.uiSettings.getScalePercent() > 10.0);
        this.zoomInButton.setEnabled(this.uiSettings.getScalePercent() < 500.0);
        this.zoomAsIsButton.setEnabled(this.uiSettings.getScalePercent() != 100.0);
    }

    public ButtonsBar createButtonsBar() {
        this.buttonsBar = new ButtonsBar();
        return this.buttonsBar;
    }

    public void setButtonsBarVisible(boolean isVisible) {
        this.setButtonsBarVisible(isVisible, this.frame);
    }

    private void setButtonsBarVisible(boolean isVisible, Container container) {
        this.buttonsBar.setVisible(isVisible);
        if (isVisible) {
            this.buttonsBar.borderOff();
            container.add((Component)this.buttonsBar.bar, "North");
            container.validate();
        } else {
            container.remove(this.buttonsBar.bar);
            this.buttonsBar.borderOn();
        }
    }

    public void setButtonsBarVisibleFS(boolean isVisible) {
        if (isVisible) {
            if (!this.buttonsBar.isVisible) {
                this.lpane.add(this.buttonsBar.bar, JLayeredPane.POPUP_LAYER, 0);
                int bbWidth = ((ButtonsBar)this.buttonsBar).bar.getPreferredSize().width;
                this.buttonsBar.bar.setBounds(this.scroller.getViewport().getViewPosition().x + (this.scroller.getWidth() - bbWidth) / 2, 0, bbWidth, ((ButtonsBar)this.buttonsBar).bar.getPreferredSize().height);
                if (null == this.buttonsBarMouseAdapter) {
                    this.buttonsBarMouseAdapter = new EmptyButtonsBarMouseAdapter();
                }
                this.buttonsBar.bar.addMouseListener(this.buttonsBarMouseAdapter);
            }
        } else {
            this.buttonsBar.bar.removeMouseListener(this.buttonsBarMouseAdapter);
            this.lpane.remove(this.buttonsBar.bar);
            this.lpane.repaint(this.buttonsBar.bar.getBounds());
        }
        this.buttonsBar.setVisible(isVisible);
        this.lpane.repaint();
        this.lpane.validate();
        this.buttonsBar.bar.validate();
    }

    public IRepaintController getRepaintController() {
        return this.surface;
    }

    void close() {
        if (this.isSeparateFrame && this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    @Override
    public void mouseEnteredEvent(MouseEvent mouseEvent) {
        this.setSurfaceToHandleKbdFocus();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.surface.addMouseListener(mouseListener);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setVisible() {
        this.container.setVisible(true);
    }

    public void validate() {
        this.container.validate();
    }

    protected void createButtonsPanel(final Protocol protocol, Container container, boolean isApplet) {
        ButtonsBar buttonsBar = this.createButtonsBar();
        buttonsBar.addToNoFullScreenGroup(buttonsBar.createButton("options", "Set Options", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.showOptionsDialog();
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        }));
        buttonsBar.addToNoFullScreenGroup(buttonsBar.createButton("info", "Show connection info", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.showConnectionInfoMessage();
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        }));
        buttonsBar.addToNoFullScreenGroup(buttonsBar.createStrut());
        buttonsBar.createButton("refresh", "Refresh screen", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                protocol.sendRefreshMessage();
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.addZoomButtons();
        this.kbdButtons = new LinkedList<JComponent>();
        buttonsBar.createStrut();
        JButton ctrlAltDelButton = buttonsBar.createButton("ctrl-alt-del", "Send 'Ctrl-Alt-Del'", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.sendCtrlAltDel(protocol);
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(ctrlAltDelButton);
        JButton winButton = buttonsBar.createButton("win", "Send 'Win' key as 'Ctrl-Esc'", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.sendWinKey(protocol);
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(winButton);
        JToggleButton ctrlButton = buttonsBar.createToggleButton("ctrl", "Ctrl Lock", new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    protocol.sendMessage(new KeyEventMessage(65507, true));
                } else {
                    protocol.sendMessage(new KeyEventMessage(65507, false));
                }
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(ctrlButton);
        JToggleButton altButton = buttonsBar.createToggleButton("alt", "Alt Lock", new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    protocol.sendMessage(new KeyEventMessage(65513, true));
                } else {
                    protocol.sendMessage(new KeyEventMessage(65513, false));
                }
                SwingViewerWindow.this.setSurfaceToHandleKbdFocus();
            }
        });
        this.kbdButtons.add(altButton);
        ModifierButtonEventListener modifierButtonListener = new ModifierButtonEventListener();
        modifierButtonListener.addButton(17, ctrlButton);
        modifierButtonListener.addButton(18, altButton);
        this.surface.addModifierListener(modifierButtonListener);
        buttonsBar.createStrut();
        buttonsBar.createButton("close", isApplet ? "Disconnect" : "Close", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingViewerWindow.this.close();
                SwingViewerWindow.this.presenter.setNeedReconnection(false);
                SwingViewerWindow.this.presenter.cancelConnection();
                SwingViewerWindow.this.fireCloseApp();
            }
        }).setAlignmentX(1.0f);
        this.setButtonsBarVisible(true, container);
    }

    private void fireCloseApp() {
        if (this.viewerEventsListener != null) {
            this.viewerEventsListener.onViewerComponentClosing();
        }
    }

    private void sendCtrlAltDel(Protocol protocol) {
        protocol.sendMessage(new KeyEventMessage(65507, true));
        protocol.sendMessage(new KeyEventMessage(65513, true));
        protocol.sendMessage(new KeyEventMessage(65535, true));
        protocol.sendMessage(new KeyEventMessage(65535, false));
        protocol.sendMessage(new KeyEventMessage(65513, false));
        protocol.sendMessage(new KeyEventMessage(65507, false));
    }

    private void sendWinKey(Protocol protocol) {
        protocol.sendMessage(new KeyEventMessage(65507, true));
        protocol.sendMessage(new KeyEventMessage(65307, true));
        protocol.sendMessage(new KeyEventMessage(65307, false));
        protocol.sendMessage(new KeyEventMessage(65507, false));
    }

    @Override
    public void settingsChanged(SettingsChangedEvent e) {
        if (ProtocolSettings.isRfbSettingsChangedFired(e)) {
            ProtocolSettings settings = (ProtocolSettings)e.getSource();
            this.setEnabledKbdButtons(!settings.isViewOnly());
        }
    }

    private void setEnabledKbdButtons(boolean enabled) {
        if (this.kbdButtons != null) {
            for (JComponent b : this.kbdButtons) {
                b.setEnabled(enabled);
            }
        }
    }

    private void showOptionsDialog() {
        OptionsDialog optionsDialog = new OptionsDialog((Window)this.frame);
        optionsDialog.initControlsFromSettings(this.rfbSettings, this.uiSettings, false);
        optionsDialog.setVisible(true);
        this.presenter.saveHistory();
    }

    private void showConnectionInfoMessage() {
        StringBuilder message = new StringBuilder();
        if (!Strings.isTrimmedEmpty(this.appName)) {
            message.append(this.appName).append("\n\n");
        }
        message.append("Connected to: ").append(this.remoteDesktopName).append("\n");
        message.append("Host: ").append(this.connectionString).append("\n\n");
        message.append("Desktop geometry: ").append(String.valueOf(this.surface.getWidth())).append(" \u00d7 ").append(String.valueOf(this.surface.getHeight())).append("\n");
        message.append("Color format: ").append(String.valueOf(Math.round(Math.pow(2.0, this.workingProtocol.getPixelFormat().depth)))).append(" colors (").append(String.valueOf(this.workingProtocol.getPixelFormat().depth)).append(" bits)\n");
        message.append("Current protocol version: ").append((Object)this.workingProtocol.getProtocolVersion());
        if (this.workingProtocol.isTight()) {
            message.append(" tight");
            if (this.workingProtocol.getTunnelType() != null && this.workingProtocol.getTunnelType() != TunnelType.NOTUNNEL) {
                message.append(" using ").append(this.workingProtocol.getTunnelType().hrName).append(" tunneling");
            }
        }
        message.append("\n");
        JOptionPane infoPane = new JOptionPane(message.toString(), 1);
        JDialog infoDialog = infoPane.createDialog(this.frame, "VNC connection info");
        infoDialog.setModalityType(Dialog.ModalityType.MODELESS);
        infoDialog.setVisible(true);
    }

    private class FullscreenBorderDetectionThread
    extends Thread {
        public static final int SHOW_HIDE_BUTTONS_BAR_DELAY_IN_MILLS = 700;
        private final JFrame frame;
        private ScheduledExecutorService scheduler;
        private ScheduledFuture<?> futureForShow;
        private ScheduledFuture<?> futureForHide;
        private Point mousePoint;
        private Point oldMousePoint;
        private Point viewPosition;

        public FullscreenBorderDetectionThread(JFrame frame) {
            super("FS border detector");
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.frame = frame;
        }

        @Override
        public void run() {
            this.setPriority(1);
            while (SwingViewerWindow.this.isFullScreen) {
                this.mousePoint = MouseInfo.getPointerInfo().getLocation();
                if (null == this.oldMousePoint) {
                    this.oldMousePoint = this.mousePoint;
                }
                SwingUtilities.convertPointFromScreen(this.mousePoint, this.frame);
                this.viewPosition = SwingViewerWindow.this.scroller.getViewport().getViewPosition();
                this.processButtonsBarVisibility();
                boolean needScrolling = this.processVScroll() || this.processHScroll();
                this.oldMousePoint = this.mousePoint;
                if (needScrolling) {
                    this.cancelShowExecutor();
                    SwingViewerWindow.this.setButtonsBarVisibleFS(false);
                    this.makeScrolling(this.viewPosition);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }

        private boolean processHScroll() {
            if (this.mousePoint.x < 20) {
                if (this.viewPosition.x > 0) {
                    int delta = 20 - this.mousePoint.x;
                    if (this.mousePoint.y != this.oldMousePoint.y) {
                        delta *= 2;
                    }
                    this.viewPosition.x -= delta;
                    if (this.viewPosition.x < 0) {
                        this.viewPosition.x = 0;
                    }
                    return true;
                }
            } else if (this.mousePoint.x > this.frame.getWidth() - 20) {
                Rectangle viewRect = SwingViewerWindow.this.scroller.getViewport().getViewRect();
                int right = viewRect.width + viewRect.x;
                if (right < ((SwingViewerWindow)SwingViewerWindow.this).lpane.getSize().width) {
                    int delta = 20 - (this.frame.getWidth() - this.mousePoint.x);
                    if (this.mousePoint.y != this.oldMousePoint.y) {
                        delta *= 2;
                    }
                    this.viewPosition.x += delta;
                    if (this.viewPosition.x + viewRect.width > ((SwingViewerWindow)SwingViewerWindow.this).lpane.getSize().width) {
                        this.viewPosition.x = ((SwingViewerWindow)SwingViewerWindow.this).lpane.getSize().width - viewRect.width;
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean processVScroll() {
            if (this.mousePoint.y < 20) {
                if (this.viewPosition.y > 0) {
                    int delta = 20 - this.mousePoint.y;
                    if (this.mousePoint.x != this.oldMousePoint.x) {
                        delta *= 2;
                    }
                    this.viewPosition.y -= delta;
                    if (this.viewPosition.y < 0) {
                        this.viewPosition.y = 0;
                    }
                    return true;
                }
            } else if (this.mousePoint.y > this.frame.getHeight() - 20) {
                Rectangle viewRect = SwingViewerWindow.this.scroller.getViewport().getViewRect();
                int bottom = viewRect.height + viewRect.y;
                if (bottom < ((SwingViewerWindow)SwingViewerWindow.this).lpane.getSize().height) {
                    int delta = 20 - (this.frame.getHeight() - this.mousePoint.y);
                    if (this.mousePoint.x != this.oldMousePoint.x) {
                        delta *= 2;
                    }
                    this.viewPosition.y += delta;
                    if (this.viewPosition.y + viewRect.height > ((SwingViewerWindow)SwingViewerWindow.this).lpane.getSize().height) {
                        this.viewPosition.y = ((SwingViewerWindow)SwingViewerWindow.this).lpane.getSize().height - viewRect.height;
                    }
                    return true;
                }
            }
            return false;
        }

        private void processButtonsBarVisibility() {
            if (this.mousePoint.y < 1) {
                this.cancelHideExecutor();
                if (!SwingViewerWindow.this.buttonsBar.isVisible && (null == this.futureForShow || this.futureForShow.isDone())) {
                    this.futureForShow = this.scheduler.schedule(new Runnable(){

                        @Override
                        public void run() {
                            FullscreenBorderDetectionThread.this.showButtonsBar();
                        }
                    }, 700L, TimeUnit.MILLISECONDS);
                }
            } else {
                this.cancelShowExecutor();
            }
            if (SwingViewerWindow.this.buttonsBar.isVisible && this.mousePoint.y <= SwingViewerWindow.this.buttonsBar.getHeight()) {
                this.cancelHideExecutor();
            }
            if (SwingViewerWindow.this.buttonsBar.isVisible && this.mousePoint.y > SwingViewerWindow.this.buttonsBar.getHeight() && (null == this.futureForHide || this.futureForHide.isDone())) {
                this.futureForHide = this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SwingViewerWindow.this.setButtonsBarVisibleFS(false);
                                SwingViewerWindow.this.frame.validate();
                            }
                        });
                    }
                }, 700L, TimeUnit.MILLISECONDS);
            }
        }

        private void cancelHideExecutor() {
            this.cancelExecutor(this.futureForHide);
        }

        private void cancelShowExecutor() {
            this.cancelExecutor(this.futureForShow);
        }

        private void cancelExecutor(ScheduledFuture<?> future) {
            if (future != null && !future.isDone()) {
                future.cancel(true);
            }
        }

        private void makeScrolling(final Point viewPosition) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingViewerWindow.this.scroller.getViewport().setViewPosition(viewPosition);
                    Point mousePosition = SwingViewerWindow.this.surface.getMousePosition();
                    if (mousePosition != null) {
                        MouseEvent mouseEvent = new MouseEvent(FullscreenBorderDetectionThread.this.frame, 0, 0L, 0, mousePosition.x, mousePosition.y, 0, false);
                        for (MouseMotionListener mml : SwingViewerWindow.this.surface.getMouseMotionListeners()) {
                            mml.mouseMoved(mouseEvent);
                        }
                    }
                }
            });
        }

        private void showButtonsBar() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingViewerWindow.this.setButtonsBarVisibleFS(true);
                }
            });
        }
    }

    private static class EmptyButtonsBarMouseAdapter
    extends MouseAdapter {
        private EmptyButtonsBarMouseAdapter() {
        }
    }

    public static class ButtonsBar {
        private static final Insets BUTTONS_MARGIN = new Insets(2, 2, 2, 2);
        private JPanel bar;
        private boolean isVisible;
        private ArrayList<Component> noFullScreenGroup = new ArrayList();

        public ButtonsBar() {
            this.bar = new JPanel(new FlowLayout(0, 4, 1));
        }

        public JButton createButton(String iconId, String tooltipText, ActionListener actionListener) {
            JButton button = new JButton(Utils.getButtonIcon(iconId));
            button.setToolTipText(tooltipText);
            button.setMargin(BUTTONS_MARGIN);
            this.bar.add(button);
            button.addActionListener(actionListener);
            return button;
        }

        public Component createStrut() {
            return this.bar.add(Box.createHorizontalStrut(10));
        }

        public JToggleButton createToggleButton(String iconId, String tooltipText, ItemListener itemListener) {
            JToggleButton button = new JToggleButton(Utils.getButtonIcon(iconId));
            button.setToolTipText(tooltipText);
            button.setMargin(BUTTONS_MARGIN);
            this.bar.add(button);
            button.addItemListener(itemListener);
            return button;
        }

        public void setVisible(boolean isVisible) {
            this.isVisible = isVisible;
            if (isVisible) {
                this.bar.revalidate();
            }
        }

        public int getWidth() {
            return this.bar.getMinimumSize().width;
        }

        public int getHeight() {
            return this.bar.getMinimumSize().height;
        }

        public void borderOn() {
            this.bar.setBorder(BorderFactory.createBevelBorder(0));
        }

        public void borderOff() {
            this.bar.setBorder(BorderFactory.createEmptyBorder());
        }

        public void addToNoFullScreenGroup(Component component) {
            this.noFullScreenGroup.add(component);
        }

        public void setNoFullScreenGroupVisible(boolean isVisible) {
            for (Component c : this.noFullScreenGroup) {
                c.setVisible(isVisible);
            }
        }
    }
}

