/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.IRequestString;
import com.glavsoft.rfb.IRfbSessionListener;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.transport.BaudrateMeter;
import com.glavsoft.transport.Transport;
import com.glavsoft.utils.Strings;
import com.glavsoft.utils.ViewerControlApi;
import com.glavsoft.viewer.settings.UiSettings;
import com.glavsoft.viewer.swing.ClipboardControllerImpl;
import com.glavsoft.viewer.swing.ConnectionErrorException;
import com.glavsoft.viewer.swing.ConnectionPresenter;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import com.glavsoft.viewer.swing.gui.RequestSomethingDialog;
import com.glavsoft.viewer.workers.ConnectionWorker;
import com.glavsoft.viewer.workers.RfbConnectionWorker;
import java.awt.Component;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class SwingRfbConnectionWorker
extends SwingWorker<Void, String>
implements RfbConnectionWorker,
IRfbSessionListener {
    private String predefinedPassword;
    private ConnectionPresenter presenter;
    private Component parent;
    private SwingViewerWindowFactory viewerWindowFactory;
    private Logger logger;
    private volatile boolean isStoppingProcess;
    private SwingViewerWindow viewerWindow;
    private String connectionString;
    private Protocol workingProtocol;
    private Socket workingSocket;
    private ProtocolSettings rfbSettings;
    private UiSettings uiSettings;
    private ViewerControlApi viewerControlApi;

    @Override
    public Void doInBackground() throws Exception {
        if (null == this.workingSocket) {
            throw new ConnectionErrorException("Null socket");
        }
        this.workingSocket.setTcpNoDelay(true);
        Transport transport = new Transport(this.workingSocket);
        BaudrateMeter baudrateMeter = new BaudrateMeter();
        transport.setBaudrateMeter(baudrateMeter);
        this.workingProtocol = new Protocol(transport, new PasswordChooser(this.connectionString, this.parent, this), this.rfbSettings);
        this.workingProtocol.setConnectionIdRetriever(new ConnectionIdChooser(this.parent, this));
        this.viewerControlApi = new ViewerControlApi(this.workingProtocol, baudrateMeter);
        String message = "Handshaking with remote host";
        this.logger.info(message);
        this.publish(message);
        this.workingProtocol.handshake();
        return null;
    }

    public SwingRfbConnectionWorker(String predefinedPassword, ConnectionPresenter presenter, Component parent, SwingViewerWindowFactory viewerWindowFactory) {
        this.predefinedPassword = predefinedPassword;
        this.presenter = presenter;
        this.parent = parent;
        this.viewerWindowFactory = viewerWindowFactory;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @Override
    protected void process(List<String> strings) {
        String message = strings.get(strings.size() - 1);
        this.presenter.showMessage(message);
    }

    @Override
    protected void done() {
        try {
            this.get();
            this.presenter.showMessage("Handshake established");
            ClipboardControllerImpl clipboardController = new ClipboardControllerImpl(this.workingProtocol, this.rfbSettings.getRemoteCharsetName());
            clipboardController.setEnabled(this.rfbSettings.isAllowClipboardTransfer());
            this.rfbSettings.addListener(clipboardController);
            this.viewerWindow = this.viewerWindowFactory.createViewerWindow(this.workingProtocol, this.rfbSettings, this.uiSettings, this.connectionString, this.presenter);
            this.workingProtocol.startNormalHandling(this, this.viewerWindow.getRepaintController(), clipboardController);
            this.presenter.showMessage("Started");
            this.presenter.successfulRfbConnection();
        }
        catch (CancellationException e) {
            this.logger.info("Cancelled");
            this.presenter.showMessage("Cancelled");
            this.presenter.connectionCancelled();
        }
        catch (InterruptedException e) {
            this.logger.info("Interrupted");
            this.presenter.showMessage("Interrupted");
            this.presenter.connectionFailed();
        }
        catch (ExecutionException ee) {
            String errorMessage;
            String errorTitle;
            try {
                throw ee.getCause();
            }
            catch (UnsupportedProtocolVersionException e) {
                errorTitle = "Unsupported Protocol Version";
                errorMessage = e.getMessage();
                this.logger.severe(errorTitle + ": " + errorMessage);
            }
            catch (UnsupportedSecurityTypeException e) {
                errorTitle = "Unsupported Security Type";
                errorMessage = e.getMessage();
                this.logger.severe(errorTitle + ": " + errorMessage);
            }
            catch (AuthenticationFailedException e) {
                errorTitle = "Authentication Failed";
                errorMessage = e.getMessage();
                this.logger.severe(errorTitle + ": " + errorMessage);
                this.presenter.clearPredefinedPassword();
            }
            catch (TransportException e) {
                errorTitle = "Connection Error";
                Throwable cause = e.getCause();
                errorMessage = errorTitle + " : " + e.getMessage();
                if (cause != null) {
                    if (cause instanceof EOFException) {
                        errorMessage = errorMessage + ", possible reason: remote host not responding.";
                    }
                    this.logger.throwing("", "", cause);
                }
                this.logger.severe(errorMessage);
            }
            catch (EOFException e) {
                errorTitle = "Connection Error";
                errorMessage = errorTitle + ": " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (IOException e) {
                errorTitle = "Connection Error";
                errorMessage = errorTitle + ":  " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (FatalException e) {
                errorTitle = "Connection Error";
                errorMessage = errorTitle + ":    " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            catch (Throwable e) {
                errorTitle = "Error";
                errorMessage = errorTitle + ": " + e.getMessage();
                this.logger.severe(errorMessage);
            }
            this.presenter.showReconnectDialog(errorTitle, errorMessage);
            this.presenter.clearMessage();
            this.presenter.connectionFailed();
        }
    }

    @Override
    public void rfbSessionStopped(final String reason) {
        if (this.workingProtocol != null) {
            this.workingProtocol.cleanUpSession();
        }
        if (this.isStoppingProcess) {
            return;
        }
        this.cleanUpUISessionAndConnection();
        this.logger.info("Rfb session stopped: " + reason);
        if (this.presenter.needReconnection()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingRfbConnectionWorker.this.presenter.showReconnectDialog("Connection error", reason);
                    SwingRfbConnectionWorker.this.presenter.reconnect(SwingRfbConnectionWorker.this.predefinedPassword);
                }
            });
        }
    }

    @Override
    public boolean cancel() {
        boolean res = super.cancel(true);
        if (res && this.workingProtocol != null) {
            this.workingProtocol.cleanUpSession();
        }
        this.cleanUpUISessionAndConnection();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpUISessionAndConnection() {
        SwingRfbConnectionWorker swingRfbConnectionWorker = this;
        synchronized (swingRfbConnectionWorker) {
            this.isStoppingProcess = true;
        }
        if (this.workingSocket != null && this.workingSocket.isConnected()) {
            try {
                this.workingSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.viewerWindow != null) {
            this.viewerWindow.close();
        }
        swingRfbConnectionWorker = this;
        synchronized (swingRfbConnectionWorker) {
            this.isStoppingProcess = false;
        }
    }

    @Override
    public void setWorkingSocket(Socket workingSocket) {
        this.workingSocket = workingSocket;
    }

    @Override
    public void setRfbSettings(ProtocolSettings rfbSettings) {
        this.rfbSettings = rfbSettings;
    }

    @Override
    public void setUiSettings(UiSettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    @Override
    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    @Override
    public ViewerControlApi getViewerControlApi() {
        return this.viewerControlApi;
    }

    private class ConnectionIdChooser
    implements IRequestString {
        private final Component parent;
        private final ConnectionWorker<Void> onCancel;

        public ConnectionIdChooser(Component parent, ConnectionWorker<Void> onCancel) {
            this.parent = parent;
            this.onCancel = onCancel;
        }

        @Override
        public String getResult() {
            RequestSomethingDialog dialog = new RequestSomethingDialog(this.parent, "TcpDispatcher ConnectionId", false, "TcpDispatcher requires Connection Id.", "Please get the Connection Id from you peer by any other communication channel\n(ex. phone call or IM) and insert it into the form field below.", "Connection Id:").setInputFieldLength(18);
            if (!dialog.askResult()) {
                this.onCancel.cancel();
            }
            return dialog.getResult();
        }
    }

    private class PasswordChooser
    implements IRequestString {
        private String connectionString;
        private final Component parent;
        private final ConnectionWorker onCancel;

        private PasswordChooser(String connectionString, Component parent, ConnectionWorker onCancel) {
            this.connectionString = connectionString;
            this.parent = parent;
            this.onCancel = onCancel;
        }

        @Override
        public String getResult() {
            return Strings.isTrimmedEmpty(SwingRfbConnectionWorker.this.predefinedPassword) ? this.askPassword() : SwingRfbConnectionWorker.this.predefinedPassword;
        }

        private String askPassword() {
            RequestSomethingDialog dialog = new RequestSomethingDialog(this.parent, "VNC Authentication", true, "Server '" + this.connectionString + "' requires VNC authentication", "Password:").setOkLabel("Login").setInputFieldLength(12);
            if (!dialog.askResult()) {
                this.onCancel.cancel();
            }
            return dialog.getResult();
        }
    }
}

