/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.auth;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.ClosedConnectionException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.encoding.ServerInitMessage;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.auth.SecurityType;
import com.glavsoft.transport.Transport;
import java.util.logging.Logger;

public abstract class AuthHandler {
    private static final int AUTH_RESULT_OK = 0;
    private Logger logger;

    protected Logger logger() {
        if (null == this.logger) {
            this.logger = Logger.getLogger(this.getClass().getName());
        }
        return this.logger;
    }

    public abstract Transport authenticate(Transport var1, Protocol var2) throws TransportException, FatalException, UnsupportedSecurityTypeException;

    public abstract SecurityType getType();

    public int getId() {
        return this.getType().getId();
    }

    public String getName() {
        return this.getType().name();
    }

    public void checkSecurityResult(Transport transport) throws TransportException, AuthenticationFailedException {
        int securityResult = transport.readInt32();
        this.logger().fine("Security result: " + securityResult + (0 == securityResult ? " (OK)" : " (Failed)"));
        if (securityResult != 0) {
            try {
                String reason = transport.readString();
                this.logger().fine("Security result reason: " + reason);
                throw new AuthenticationFailedException(reason);
            }
            catch (ClosedConnectionException e) {
                throw new AuthenticationFailedException("Authentication failed");
            }
        }
    }

    public void initProcedure(Transport transport, Protocol protocol) throws TransportException {
        this.sendClientInitMessage(transport, protocol.getSettings().getSharedFlag());
        ServerInitMessage serverInitMessage = this.readServerInitMessage(transport);
        this.completeContextData(serverInitMessage, protocol);
        protocol.registerRfbEncodings();
    }

    protected ServerInitMessage readServerInitMessage(Transport transport) throws TransportException {
        ServerInitMessage serverInitMessage = new ServerInitMessage().readFrom(transport);
        this.logger().fine("Read: " + serverInitMessage);
        return serverInitMessage;
    }

    protected void sendClientInitMessage(Transport transport, byte sharedFlag) throws TransportException {
        this.logger().fine("Sent client-init-message: " + sharedFlag);
        transport.writeByte(sharedFlag).flush();
    }

    protected void completeContextData(ServerInitMessage serverInitMessage, Protocol protocol) {
        protocol.setServerPixelFormat(serverInitMessage.getPixelFormat());
        protocol.setFbWidth(serverInitMessage.getFramebufferWidth());
        protocol.setFbHeight(serverInitMessage.getFramebufferHeight());
        protocol.setRemoteDesktopName(serverInitMessage.getName());
    }
}

