/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.encoding.decoder.RawDecoder;
import com.glavsoft.transport.Transport;

public class HextileDecoder
extends Decoder {
    private static final int DEFAULT_TILE_SIZE = 16;
    private static final int RAW_MASK = 1;
    private static final int BACKGROUND_SPECIFIED_MASK = 2;
    private static final int FOREGROUND_SPECIFIED_MASK = 4;
    private static final int ANY_SUBRECTS_MASK = 8;
    private static final int SUBRECTS_COLOURED_MASK = 16;
    private static final int FG_COLOR_INDEX = 0;
    private static final int BG_COLOR_INDEX = 1;

    @Override
    public void decode(Transport transport, Renderer renderer, FramebufferUpdateRectangle rect) throws TransportException {
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        int[] colors = new int[]{-1, -1};
        int maxX = rect.x + rect.width;
        int maxY = rect.y + rect.height;
        for (int tileY = rect.y; tileY < maxY; tileY += 16) {
            int tileHeight = Math.min(maxY - tileY, 16);
            for (int tileX = rect.x; tileX < maxX; tileX += 16) {
                int tileWidth = Math.min(maxX - tileX, 16);
                this.decodeTile(transport, renderer, colors, tileX, tileY, tileWidth, tileHeight);
            }
        }
    }

    private void decodeTile(Transport transport, Renderer renderer, int[] colors, int tileX, int tileY, int tileWidth, int tileHeight) throws TransportException {
        int subencoding = transport.readUInt8();
        if ((subencoding & 1) != 0) {
            RawDecoder.getInstance().decode(transport, renderer, tileX, tileY, tileWidth, tileHeight);
            return;
        }
        if ((subencoding & 2) != 0) {
            colors[1] = renderer.readPixelColor(transport);
        }
        renderer.fillRect(colors[1], tileX, tileY, tileWidth, tileHeight);
        if ((subencoding & 4) != 0) {
            colors[0] = renderer.readPixelColor(transport);
        }
        if ((subencoding & 8) == 0) {
            return;
        }
        int numberOfSubrectangles = transport.readUInt8();
        boolean colorSpecified = (subencoding & 0x10) != 0;
        for (int i = 0; i < numberOfSubrectangles; ++i) {
            int color;
            colors[0] = color = colorSpecified ? renderer.readPixelColor(transport) : colors[0];
            byte dimensions = transport.readByte();
            int subtileX = dimensions >> 4 & 0xF;
            int subtileY = dimensions & 0xF;
            dimensions = transport.readByte();
            int subtileWidth = 1 + (dimensions >> 4 & 0xF);
            int subtileHeight = 1 + (dimensions & 0xF);
            renderer.fillRect(color, tileX + subtileX, tileY + subtileY, subtileWidth, subtileHeight);
        }
    }
}

