/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.client;

public enum ClientMessageType {
    SET_PIXEL_FORMAT(0),
    SET_ENCODINGS(2),
    FRAMEBUFFER_UPDATE_REQUEST(3),
    KEY_EVENT(4),
    POINTER_EVENT(5),
    CLIENT_CUT_TEXT(6),
    VIDEO_RECTANGLE_SELECTION(151),
    VIDEO_FREEZE(152);

    public final int id;
    private static final ClientMessageType[] standardTypes;

    private ClientMessageType(int id) {
        this.id = id;
    }

    public static boolean isStandardType(ClientMessageType type) {
        for (ClientMessageType it : standardTypes) {
            if (it != type) continue;
            return true;
        }
        return false;
    }

    public static ClientMessageType byId(int id) {
        for (ClientMessageType type : ClientMessageType.values()) {
            if (type.id != id) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported client message type: " + id);
    }

    static {
        standardTypes = new ClientMessageType[]{SET_PIXEL_FORMAT, SET_ENCODINGS, FRAMEBUFFER_UPDATE_REQUEST, KEY_EVENT, POINTER_EVENT, CLIENT_CUT_TEXT};
    }
}

