/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.drawing;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.transport.Transport;

public class ColorDecoder {
    protected byte redShift;
    protected byte greenShift;
    protected byte blueShift;
    public short redMax;
    public short greenMax;
    public short blueMax;
    public final int bytesPerPixel;
    public final int bytesPerCPixel;
    public final int bytesPerPixelTight;
    private final byte[] buff;
    private int startShift;
    private int startShiftCompact;
    private int addShiftItem;
    private final boolean isTightSpecific;

    public ColorDecoder(PixelFormat pf) {
        this.redShift = pf.redShift;
        this.greenShift = pf.greenShift;
        this.blueShift = pf.blueShift;
        this.redMax = pf.redMax;
        this.greenMax = pf.greenMax;
        this.blueMax = pf.blueMax;
        this.bytesPerPixel = pf.bitsPerPixel / 8;
        long significant = this.redMax << this.redShift | this.greenMax << this.greenShift | this.blueMax << this.blueShift;
        this.bytesPerCPixel = pf.depth <= 24 && 32 == pf.bitsPerPixel && ((significant & 0xFF000000L) == 0L || (significant & 0xFFL) == 0L) ? 3 : this.bytesPerPixel;
        this.bytesPerPixelTight = 24 == pf.depth && 32 == pf.bitsPerPixel ? 3 : this.bytesPerPixel;
        this.buff = new byte[this.bytesPerPixel];
        if (0 == pf.bigEndianFlag) {
            this.startShift = 0;
            this.startShiftCompact = 0;
            this.addShiftItem = 8;
        } else {
            this.startShift = pf.bitsPerPixel - 8;
            this.startShiftCompact = Math.max(0, pf.depth - 8);
            this.addShiftItem = -8;
        }
        this.isTightSpecific = 4 == this.bytesPerPixel && 3 == this.bytesPerPixelTight && 255 == this.redMax && 255 == this.greenMax && 255 == this.blueMax;
    }

    protected int readColor(Transport transport) throws TransportException {
        return this.getColor(transport.readBytes(this.buff, 0, this.bytesPerPixel), 0);
    }

    protected int readCompactColor(Transport transport) throws TransportException {
        return this.getCompactColor(transport.readBytes(this.buff, 0, this.bytesPerCPixel), 0);
    }

    protected int readTightColor(Transport transport) throws TransportException {
        return this.getTightColor(transport.readBytes(this.buff, 0, this.bytesPerPixelTight), 0);
    }

    protected int convertColor(int rawColor) {
        return 255 * (rawColor >> this.redShift & this.redMax) / this.redMax << 16 | 255 * (rawColor >> this.greenShift & this.greenMax) / this.greenMax << 8 | 255 * (rawColor >> this.blueShift & this.blueMax) / this.blueMax;
    }

    public void fillRawComponents(byte[] comp, byte[] bytes, int offset) {
        int rawColor = this.getRawTightColor(bytes, offset);
        comp[0] = (byte)(rawColor >> this.redShift & this.redMax);
        comp[1] = (byte)(rawColor >> this.greenShift & this.greenMax);
        comp[2] = (byte)(rawColor >> this.blueShift & this.blueMax);
    }

    public int getTightColor(byte[] bytes, int offset) {
        return this.convertColor(this.getRawTightColor(bytes, offset));
    }

    private int getRawTightColor(byte[] bytes, int offset) {
        if (this.isTightSpecific) {
            return (bytes[offset++] & 0xFF) << 16 | (bytes[offset++] & 0xFF) << 8 | bytes[offset] & 0xFF;
        }
        return this.getRawColor(bytes, offset);
    }

    protected int getColor(byte[] bytes, int offset) {
        return this.convertColor(this.getRawColor(bytes, offset));
    }

    private int getRawColor(byte[] bytes, int offset) {
        int shift = this.startShift;
        int item = this.addShiftItem;
        int rawColor = (bytes[offset++] & 0xFF) << shift;
        for (int i = 1; i < this.bytesPerPixel; ++i) {
            rawColor |= (bytes[offset++] & 0xFF) << (shift += item);
        }
        return rawColor;
    }

    protected int getCompactColor(byte[] bytes, int offset) {
        int shift = this.startShiftCompact;
        int item = this.addShiftItem;
        int rawColor = (bytes[offset++] & 0xFF) << shift;
        for (int i = 1; i < this.bytesPerCPixel; ++i) {
            rawColor |= (bytes[offset++] & 0xFF) << (shift += item);
        }
        return this.convertColor(rawColor);
    }
}

