/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import com.glavsoft.viewer.swing.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class RequestSomethingDialog
extends JDialog {
    private static final int DEFAULT_INPUT_FIELD_LENGTH = 20;
    private static final String OK = "Ok";
    private static final String CANCEL = "Cancel";
    private static final int PAD = 8;
    private String answer = "";
    private Boolean result = false;
    private String okLabel;
    private String cancelLabel;
    private int inputFieldLength = 20;

    public RequestSomethingDialog(Component parent, String title, final boolean isPassword, String ... messages) {
        super((Window)parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        this.setDefaultCloseOperation(2);
        final JTextField inputField = isPassword ? new JPasswordField(this.inputFieldLength) : new JTextField(this.inputFieldLength);
        JPanel outerPane = new JPanel(new BorderLayout(8, 8));
        outerPane.setBorder(new EmptyBorder(8, 16, 16, 16));
        List<Image> applicationIcons = Utils.getApplicationIcons();
        if (!applicationIcons.isEmpty()) {
            JLabel iconLabel = new JLabel(new ImageIcon(applicationIcons.get(applicationIcons.size() - 1).getScaledInstance(64, 64, 4)));
            outerPane.add((Component)iconLabel, "West");
            iconLabel.setBorder(new EmptyBorder(8, 16, 8, 16));
        }
        JPanel listPane = new JPanel();
        outerPane.add((Component)listPane, "Center");
        listPane.setLayout(new BoxLayout(listPane, 3));
        listPane.add(Box.createVerticalStrut(8));
        if (messages.length > 0) {
            for (int i = 0; i < messages.length - 1; ++i) {
                JLabel label = new JLabel(messages[i]);
                label.setAlignmentX(0.0f);
                listPane.add(label);
                listPane.add(Box.createVerticalStrut(8));
            }
            String last = messages[messages.length - 1];
            if (last.endsWith(":")) {
                JPanel inputPanel = new JPanel();
                inputPanel.setLayout(new BoxLayout(inputPanel, 2));
                JLabel label = new JLabel(last);
                label.setAlignmentX(0.0f);
                inputPanel.add(label);
                inputPanel.add(inputField);
                inputPanel.setAlignmentX(0.0f);
                listPane.add(inputPanel);
            } else {
                inputField.setAlignmentX(0.0f);
                listPane.add(inputField);
            }
        } else {
            inputField.setAlignmentX(0.0f);
            listPane.add(inputField);
        }
        listPane.add(Box.createVerticalStrut(16));
        if (null == this.okLabel) {
            this.okLabel = OK;
        }
        if (null == this.cancelLabel) {
            this.cancelLabel = CANCEL;
        }
        JPanel buttonsPane = new JPanel();
        buttonsPane.setLayout(new BoxLayout(buttonsPane, 2));
        JButton okButton = new JButton(new AbstractAction(this.okLabel){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSomethingDialog.this.result = true;
                RequestSomethingDialog.this.answer = isPassword ? new String(((JPasswordField)inputField).getPassword()) : inputField.getText();
                RequestSomethingDialog.this.dispatchEvent(new WindowEvent(RequestSomethingDialog.this, 201));
            }
        });
        JButton cancelButton = new JButton(new AbstractAction(this.cancelLabel){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestSomethingDialog.this.result = false;
                RequestSomethingDialog.this.answer = "";
                RequestSomethingDialog.this.setVisible(false);
                RequestSomethingDialog.this.dispatchEvent(new WindowEvent(RequestSomethingDialog.this, 201));
            }
        });
        buttonsPane.add(Box.createHorizontalGlue());
        buttonsPane.add(cancelButton);
        buttonsPane.add(Box.createHorizontalStrut(8));
        buttonsPane.add(okButton);
        outerPane.add((Component)buttonsPane, "South");
        this.add(outerPane);
        this.getRootPane().setDefaultButton(okButton);
        if (!inputField.requestFocusInWindow()) {
            inputField.requestFocus();
        }
        this.pack();
        Utils.decorateDialog(this);
        Utils.centerWindow(this);
    }

    public RequestSomethingDialog setOkLabel(String okLabel) {
        this.okLabel = okLabel;
        return this;
    }

    public RequestSomethingDialog setCancelLabel(String cancelLabel) {
        this.cancelLabel = cancelLabel;
        return this;
    }

    public RequestSomethingDialog setInputFieldLength(int inputFieldLength) {
        this.inputFieldLength = inputFieldLength;
        return this;
    }

    public boolean askResult() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    RequestSomethingDialog.this.setVisible(true);
                }
            });
        }
        catch (InterruptedException e) {
            Logger.getLogger(this.getClass().getName()).severe(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Logger.getLogger(this.getClass().getName()).severe(e.getMessage());
        }
        return this.result;
    }

    public String getResult() {
        return this.answer;
    }
}

