/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import com.glavsoft.viewer.swing.ConnectionPresenter;
import com.glavsoft.viewer.swing.Utils;
import com.glavsoft.viewer.swing.ViewerEventsListener;
import com.glavsoft.viewer.swing.gui.ConnectionView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ConnectionInfoView
extends JFrame
implements ConnectionView {
    private static final String CANCEL = "Cancel";
    private static final int PAD = 8;
    private static final String CLOSE = "Close";
    private ViewerEventsListener onCloseListener;
    private final ConnectionPresenter presenter;
    private final JLabel messageLabel;
    private final JLabel infoLabel;
    private final JButton cancelOrCloseButton;

    public ConnectionInfoView(ViewerEventsListener onCloseListener, final ConnectionPresenter presenter) {
        super("Connection");
        this.onCloseListener = onCloseListener;
        this.presenter = presenter;
        JPanel outerPane = new JPanel(new BorderLayout(8, 8));
        outerPane.setBorder(new EmptyBorder(8, 16, 16, 16));
        List<Image> applicationIcons = Utils.getApplicationIcons();
        if (!applicationIcons.isEmpty()) {
            JLabel iconLabel = new JLabel(new ImageIcon(applicationIcons.get(applicationIcons.size() - 1).getScaledInstance(64, 64, 4)));
            outerPane.add((Component)iconLabel, "West");
            iconLabel.setBorder(new EmptyBorder(8, 16, 8, 16));
        }
        JPanel listPane = new JPanel();
        outerPane.add((Component)listPane, "Center");
        listPane.setLayout(new BoxLayout(listPane, 3));
        listPane.add(Box.createVerticalStrut(8));
        this.infoLabel = new JLabel("Connecting...");
        listPane.add(this.infoLabel);
        listPane.add(Box.createVerticalStrut(8));
        this.messageLabel = new JLabel(" ");
        listPane.add((Component)this.messageLabel, "Center");
        listPane.add(Box.createVerticalStrut(16));
        this.cancelOrCloseButton = new JButton(CANCEL);
        this.cancelOrCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionInfoView.this.dispatchEvent(new WindowEvent(ConnectionInfoView.this, 201));
            }
        });
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.cancelOrCloseButton);
        listPane.add(buttonPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                presenter.cancelConnection();
                ConnectionInfoView.this.closeView();
                ConnectionInfoView.this.closeApp();
            }
        });
        this.add(outerPane);
        this.getRootPane().setDefaultButton(this.cancelOrCloseButton);
        this.setMinimumSize(new Dimension(300, 150));
        Utils.decorateDialog(this);
        Utils.centerWindow(this);
    }

    @Override
    public void showView() {
        this.setVisible(true);
        this.toFront();
        this.repaint();
    }

    @Override
    public void closeView() {
        this.setVisible(false);
    }

    @Override
    public void showReconnectDialog(String title, String message) {
        int val = JOptionPane.showConfirmDialog(this, message + "\nTry another connection?", title, 0, 3);
        if (1 == val) {
            this.presenter.setNeedReconnection(false);
            this.closeView();
            this.dispose();
            this.closeApp();
        }
    }

    @Override
    public void showConnectionErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Connection error", 0);
    }

    @Override
    public void closeApp() {
        if (this.onCloseListener != null) {
            this.onCloseListener.onViewerComponentClosing();
        }
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    public void setMessage(String message) {
        if (message.isEmpty()) {
            this.cancelOrCloseButton.setText(CANCEL);
        }
        if ("Cancelled".equals(message)) {
            this.cancelOrCloseButton.setText(CLOSE);
        }
        this.messageLabel.setText(message);
        this.pack();
    }

    public void setHostName(String hostName) {
        this.infoLabel.setText("Connecting to host '" + hostName + "'");
        this.pack();
    }
}

