/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing;

import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.viewer.settings.UiSettings;
import com.glavsoft.viewer.swing.ConnectionPresenter;
import com.glavsoft.viewer.swing.Surface;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import com.glavsoft.viewer.swing.ViewerEventsListener;
import java.awt.Container;

public class SwingViewerWindowFactory {
    private final boolean isSeparateFrame;
    private boolean isApplet = false;
    private final ViewerEventsListener viewerEventsListener;
    private Container externalContainer;
    private String appName;

    public SwingViewerWindowFactory(ViewerEventsListener viewerEventsListener) {
        this(true, viewerEventsListener);
    }

    public SwingViewerWindowFactory(boolean isSeparateFrame, ViewerEventsListener viewerEventsListener) {
        this.isSeparateFrame = isSeparateFrame;
        this.viewerEventsListener = viewerEventsListener;
    }

    public SwingViewerWindow createViewerWindow(Protocol workingProtocol, ProtocolSettings rfbSettings, UiSettings uiSettings, String connectionString, ConnectionPresenter presenter) {
        Surface surface = new Surface(workingProtocol, uiSettings.getScaleFactor(), uiSettings.getMouseCursorShape());
        SwingViewerWindow viewerWindow = new SwingViewerWindow(workingProtocol, rfbSettings, uiSettings, surface, this.isSeparateFrame, this.isApplet, this.viewerEventsListener, this.appName, connectionString, presenter, this.externalContainer);
        surface.setViewerWindow(viewerWindow);
        viewerWindow.setRemoteDesktopName(workingProtocol.getRemoteDesktopName());
        rfbSettings.addListener(viewerWindow);
        uiSettings.addListener(surface);
        return viewerWindow;
    }

    public void setExternalContainer(Container externalContainer) {
        this.externalContainer = externalContainer;
    }

    public void setIsApplet(boolean isApplet) {
        this.isApplet = isApplet;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

