/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.CommonException;
import com.glavsoft.exceptions.ProtocolException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.ClipboardController;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.client.FramebufferUpdateRequestMessage;
import com.glavsoft.rfb.client.SetPixelFormatMessage;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.transport.BaudrateMeter;
import com.glavsoft.transport.Transport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;

public class ReceiverTask
implements Runnable {
    private static final byte FRAMEBUFFER_UPDATE = 0;
    private static final byte SET_COLOR_MAP_ENTRIES = 1;
    private static final byte BELL = 2;
    private static final byte SERVER_CUT_TEXT = 3;
    private static Logger logger = Logger.getLogger("com.glavsoft.rfb.protocol.ReceiverTask");
    private final Transport transport;
    private Renderer renderer;
    private final IRepaintController repaintController;
    private final ClipboardController clipboardController;
    protected FramebufferUpdateRequestMessage fullscreenFbUpdateIncrementalRequest;
    private final Protocol protocol;
    private BaudrateMeter baudrateMeter;
    private PixelFormat pixelFormat;
    private volatile boolean needSendPixelFormat;

    public ReceiverTask(Transport transport, IRepaintController repaintController, ClipboardController clipboardController, Protocol protocol, BaudrateMeter baudrateMeter) {
        this.transport = transport;
        this.repaintController = repaintController;
        this.clipboardController = clipboardController;
        this.protocol = protocol;
        this.baudrateMeter = baudrateMeter;
        this.renderer = repaintController.createRenderer(transport, protocol.getFbWidth(), protocol.getFbHeight(), protocol.getPixelFormat());
        this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(0, 0, protocol.getFbWidth(), protocol.getFbHeight(), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block11: while (!Thread.currentThread().isInterrupted()) {
                byte messageId = this.transport.readByte();
                switch (messageId) {
                    case 0: {
                        this.framebufferUpdateMessage();
                        continue block11;
                    }
                    case 1: {
                        logger.severe("Server message SetColorMapEntries is not implemented. Skip.");
                        this.setColorMapEntries();
                        continue block11;
                    }
                    case 2: {
                        logger.fine("Server message: Bell");
                        System.out.print("\u00007");
                        System.out.flush();
                        continue block11;
                    }
                    case 3: {
                        logger.fine("Server message: CutText (3)");
                        this.serverCutText();
                        continue block11;
                    }
                }
                logger.severe("Unsupported server message. Id = " + messageId);
            }
        }
        catch (TransportException e) {
            logger.severe("Close session: " + e.getMessage());
            this.protocol.cleanUpSession("Connection closed.");
        }
        catch (ProtocolException e) {
            logger.severe(e.getMessage());
            this.protocol.cleanUpSession(e.getMessage() + "\nConnection closed.");
        }
        catch (CommonException e) {
            logger.severe(e.getMessage());
            this.protocol.cleanUpSession("Connection closed..");
        }
        catch (Throwable te) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            te.printStackTrace(pw);
            this.protocol.cleanUpSession(te.getMessage() + "\n" + sw.toString());
        }
        Logger.getLogger(this.getClass().getName()).finer("Receiver task stopped");
    }

    private void setColorMapEntries() throws TransportException {
        this.transport.readByte();
        this.transport.readUInt16();
        int length = this.transport.readUInt16();
        while (length-- > 0) {
            this.transport.readUInt16();
            this.transport.readUInt16();
            this.transport.readUInt16();
        }
    }

    private void serverCutText() throws TransportException {
        this.transport.readByte();
        this.transport.readInt16();
        long length = this.transport.readInt32();
        if (0L == length) {
            return;
        }
        if (length > Integer.MAX_VALUE) {
            this.clipboardController.updateSystemClipboard(this.transport.readBytes(Integer.MAX_VALUE));
            this.clipboardController.updateSystemClipboard(this.transport.readBytes((int)(length - Integer.MAX_VALUE)));
        } else {
            this.clipboardController.updateSystemClipboard(this.transport.readBytes((int)length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void framebufferUpdateMessage() throws CommonException {
        this.transport.skip(1);
        int numberOfRectangles = this.transport.readUInt16();
        while (numberOfRectangles-- > 0) {
            FramebufferUpdateRectangle rect = new FramebufferUpdateRectangle();
            rect.fill(this.transport);
            Decoder decoder = this.protocol.getDecoderByType(rect.getEncodingType());
            if (decoder != null) {
                try {
                    if (this.baudrateMeter != null) {
                        this.baudrateMeter.startMeasuringCycle();
                    }
                    decoder.decode(this.transport, this.renderer, rect);
                }
                finally {
                    if (this.baudrateMeter != null) {
                        this.baudrateMeter.stopMeasuringCycle();
                    }
                }
                if (EncodingType.RICH_CURSOR == rect.getEncodingType() || EncodingType.CURSOR_POS == rect.getEncodingType()) {
                    this.repaintController.repaintCursor();
                    continue;
                }
                if (rect.getEncodingType() == EncodingType.DESKTOP_SIZE) {
                    ReceiverTask receiverTask = this;
                    synchronized (receiverTask) {
                        this.fullscreenFbUpdateIncrementalRequest = new FramebufferUpdateRequestMessage(0, 0, rect.width, rect.height, true);
                    }
                    this.renderer = this.repaintController.createRenderer(this.transport, rect.width, rect.height, this.protocol.getPixelFormat());
                    this.protocol.sendMessage(new FramebufferUpdateRequestMessage(0, 0, rect.width, rect.height, false));
                    return;
                }
                this.repaintController.repaintBitmap(rect);
                continue;
            }
            throw new CommonException("Unprocessed encoding: " + rect.toString());
        }
        if (this.needSendPixelFormat) {
            ReceiverTask receiverTask = this;
            synchronized (receiverTask) {
                if (this.needSendPixelFormat) {
                    this.needSendPixelFormat = false;
                    this.protocol.setPixelFormat(this.pixelFormat);
                    this.protocol.sendMessage(new SetPixelFormatMessage(this.pixelFormat));
                    logger.fine("sent: " + this.pixelFormat);
                    this.protocol.sendRefreshMessage();
                    logger.fine("sent: nonincremental fb update");
                }
            }
        } else {
            this.protocol.sendMessage(this.fullscreenFbUpdateIncrementalRequest);
        }
    }

    public synchronized void queueUpdatePixelFormat(PixelFormat pf) {
        this.pixelFormat = pf;
        this.needSendPixelFormat = true;
    }
}

