/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.protocol.LocalPointer;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProtocolSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final EncodingType DEFAULT_PREFERRED_ENCODING = EncodingType.TIGHT;
    public static final int DEFAULT_JPEG_QUALITY = 6;
    private static final int DEFAULT_COMPRESSION_LEVEL = -6;
    public static final int COLOR_DEPTH_32 = 32;
    public static final int COLOR_DEPTH_24 = 24;
    public static final int COLOR_DEPTH_16 = 16;
    public static final int COLOR_DEPTH_8 = 8;
    public static final int COLOR_DEPTH_6 = 6;
    public static final int COLOR_DEPTH_3 = 3;
    public static final int COLOR_DEPTH_SERVER_SETTINGS = 0;
    private static final int DEFAULT_COLOR_DEPTH = 24;
    public static final int CHANGED_VIEW_ONLY = 1;
    public static final int CHANGED_ENCODINGS = 2;
    public static final int CHANGED_ALLOW_COPY_RECT = 4;
    public static final int CHANGED_SHOW_REMOTE_CURSOR = 8;
    public static final int CHANGED_MOUSE_CURSOR_TRACK = 16;
    public static final int CHANGED_COMPRESSION_LEVEL = 32;
    public static final int CHANGED_JPEG_QUALITY = 64;
    public static final int CHANGED_ALLOW_CLIPBOARD_TRANSFER = 128;
    public static final int CHANGED_CONVERT_TO_ASCII = 256;
    public static final int CHANGED_COLOR_DEPTH = 512;
    public static final int CHANGED_SHARED = 1024;
    private static final int MIN_COMPRESSION_LEVEL = 1;
    private static final int MAX_COMPRESSION_LEVEL = 9;
    private static final int MIN_JPEG_QUALITY = 1;
    private static final int MAX_JPEG_QUALITY = 9;
    private transient int changedSettingsMask = 0;
    private boolean sharedFlag = true;
    private boolean viewOnly = false;
    private EncodingType preferredEncoding;
    private boolean allowCopyRect = true;
    private boolean showRemoteCursor = true;
    private LocalPointer mouseCursorTrack = LocalPointer.ON;
    private int compressionLevel = -6;
    private int jpegQuality = 6;
    private boolean allowClipboardTransfer = true;
    private boolean convertToAscii = false;
    private int colorDepth = 0;
    private final transient List<IChangeSettingsListener> listeners;
    private transient String remoteCharsetName;
    private TunnelType tunnelType;

    public static ProtocolSettings getDefaultSettings() {
        return new ProtocolSettings();
    }

    private ProtocolSettings() {
        this.preferredEncoding = DEFAULT_PREFERRED_ENCODING;
        this.listeners = new CopyOnWriteArrayList<IChangeSettingsListener>();
    }

    public ProtocolSettings(ProtocolSettings s) {
        this();
        this.copyDataFrom(s);
        this.changedSettingsMask = s.changedSettingsMask;
    }

    public void copyDataFrom(ProtocolSettings s) {
        this.copyDataFrom(s, 0);
    }

    public void copyDataFrom(ProtocolSettings s, int mask) {
        if (null == s) {
            return;
        }
        if ((mask & 0x400) == 0) {
            this.setSharedFlag(s.sharedFlag);
        }
        if ((mask & 1) == 0) {
            this.setViewOnly(s.viewOnly);
        }
        if ((mask & 4) == 0) {
            this.setAllowCopyRect(s.allowCopyRect);
        }
        if ((mask & 8) == 0) {
            this.setShowRemoteCursor(s.showRemoteCursor);
        }
        if ((mask & 0x80) == 0) {
            this.setAllowClipboardTransfer(s.allowClipboardTransfer);
        }
        if ((mask & 0x10) == 0) {
            this.setMouseCursorTrack(s.mouseCursorTrack);
        }
        if ((mask & 0x20) == 0) {
            this.setCompressionLevel(s.compressionLevel);
        }
        if ((mask & 0x40) == 0) {
            this.setJpegQuality(s.jpegQuality);
        }
        if ((mask & 0x100) == 0) {
            this.setConvertToAscii(s.convertToAscii);
        }
        if ((mask & 0x200) == 0) {
            this.setColorDepth(s.colorDepth);
        }
        if ((mask & 2) == 0) {
            this.setPreferredEncoding(s.preferredEncoding);
        }
    }

    public void addListener(IChangeSettingsListener listener) {
        this.listeners.add(listener);
    }

    public byte getSharedFlag() {
        return (byte)(this.sharedFlag ? 1 : 0);
    }

    public boolean isShared() {
        return this.sharedFlag;
    }

    public void setSharedFlag(boolean sharedFlag) {
        if (this.sharedFlag != sharedFlag) {
            this.sharedFlag = sharedFlag;
            this.changedSettingsMask |= 0x400;
        }
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public void setViewOnly(boolean viewOnly) {
        if (this.viewOnly != viewOnly) {
            this.viewOnly = viewOnly;
            this.changedSettingsMask |= 1;
        }
    }

    public int getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(int depth) {
        if (this.colorDepth != depth) {
            this.changedSettingsMask |= 0x202;
            switch (depth) {
                case 32: {
                    this.colorDepth = 24;
                    break;
                }
                case 0: 
                case 3: 
                case 6: 
                case 8: 
                case 16: 
                case 24: {
                    this.colorDepth = depth;
                    break;
                }
                default: {
                    this.colorDepth = 24;
                }
            }
        }
    }

    public void fireListeners() {
        if (null == this.listeners) {
            return;
        }
        SettingsChangedEvent event = new SettingsChangedEvent(new ProtocolSettings(this));
        this.changedSettingsMask = 0;
        for (IChangeSettingsListener listener : this.listeners) {
            listener.settingsChanged(event);
        }
    }

    public static boolean isRfbSettingsChangedFired(SettingsChangedEvent event) {
        return event.getSource() instanceof ProtocolSettings;
    }

    public void setPreferredEncoding(EncodingType preferredEncoding) {
        if (this.preferredEncoding != preferredEncoding) {
            this.preferredEncoding = preferredEncoding;
            this.changedSettingsMask |= 2;
        }
    }

    public EncodingType getPreferredEncoding() {
        return this.preferredEncoding;
    }

    public void setAllowCopyRect(boolean allowCopyRect) {
        if (this.allowCopyRect != allowCopyRect) {
            this.allowCopyRect = allowCopyRect;
            this.changedSettingsMask |= 6;
        }
    }

    public boolean isAllowCopyRect() {
        return this.allowCopyRect;
    }

    private void setShowRemoteCursor(boolean showRemoteCursor) {
        if (this.showRemoteCursor != showRemoteCursor) {
            this.showRemoteCursor = showRemoteCursor;
            this.changedSettingsMask |= 0xA;
        }
    }

    public boolean isShowRemoteCursor() {
        return this.showRemoteCursor;
    }

    public void setMouseCursorTrack(LocalPointer mouseCursorTrack) {
        if (this.mouseCursorTrack != mouseCursorTrack) {
            this.mouseCursorTrack = mouseCursorTrack;
            this.changedSettingsMask |= 0x12;
            this.setShowRemoteCursor(LocalPointer.ON == mouseCursorTrack);
        }
    }

    public LocalPointer getMouseCursorTrack() {
        return this.mouseCursorTrack;
    }

    public int setCompressionLevel(int compressionLevel) {
        if (compressionLevel >= 1 && compressionLevel <= 9 && this.compressionLevel != compressionLevel) {
            this.compressionLevel = compressionLevel;
            this.changedSettingsMask |= 0x22;
        }
        return this.compressionLevel;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int setJpegQuality(int jpegQuality) {
        if (jpegQuality >= 1 && jpegQuality <= 9 && this.jpegQuality != jpegQuality) {
            this.jpegQuality = jpegQuality;
            this.changedSettingsMask |= 0x42;
        }
        return this.jpegQuality;
    }

    public int getJpegQuality() {
        return this.jpegQuality;
    }

    public void setAllowClipboardTransfer(boolean enable) {
        if (this.allowClipboardTransfer != enable) {
            this.allowClipboardTransfer = enable;
            this.changedSettingsMask |= 0x80;
        }
    }

    public boolean isAllowClipboardTransfer() {
        return this.allowClipboardTransfer;
    }

    public boolean isConvertToAscii() {
        return this.convertToAscii;
    }

    public void setConvertToAscii(boolean convertToAscii) {
        if (this.convertToAscii != convertToAscii) {
            this.convertToAscii = convertToAscii;
            this.changedSettingsMask |= 0x100;
        }
    }

    public boolean isChangedEncodings() {
        return (this.changedSettingsMask & 2) == 2;
    }

    public boolean isChangedColorDepth() {
        return (this.changedSettingsMask & 0x200) == 512;
    }

    public void setRemoteCharsetName(String remoteCharsetName) {
        this.remoteCharsetName = remoteCharsetName;
    }

    public String getRemoteCharsetName() {
        return this.remoteCharsetName;
    }

    public String toString() {
        return "ProtocolSettings{sharedFlag=" + this.sharedFlag + ", viewOnly=" + this.viewOnly + ", preferredEncoding=" + (Object)((Object)this.preferredEncoding) + ", allowCopyRect=" + this.allowCopyRect + ", showRemoteCursor=" + this.showRemoteCursor + ", mouseCursorTrack=" + (Object)((Object)this.mouseCursorTrack) + ", compressionLevel=" + this.compressionLevel + ", jpegQuality=" + this.jpegQuality + ", allowClipboardTransfer=" + this.allowClipboardTransfer + ", convertToAscii=" + this.convertToAscii + ", colorDepth=" + this.colorDepth + '}';
    }

    public TunnelType getTunnelType() {
        return this.tunnelType;
    }

    public void setTunnelType(TunnelType tunnelType) {
        this.tunnelType = tunnelType;
    }
}

