/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.core.SettingsChangedEvent;
import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.ClipboardController;
import com.glavsoft.rfb.IChangeSettingsListener;
import com.glavsoft.rfb.IRepaintController;
import com.glavsoft.rfb.IRequestString;
import com.glavsoft.rfb.IRfbSessionListener;
import com.glavsoft.rfb.RfbCapabilityInfo;
import com.glavsoft.rfb.client.ClientMessageType;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.client.FramebufferUpdateRequestMessage;
import com.glavsoft.rfb.client.SetEncodingsMessage;
import com.glavsoft.rfb.client.SetPixelFormatMessage;
import com.glavsoft.rfb.encoding.EncodingType;
import com.glavsoft.rfb.encoding.PixelFormat;
import com.glavsoft.rfb.encoding.decoder.ByteBuffer;
import com.glavsoft.rfb.encoding.decoder.CopyRectDecoder;
import com.glavsoft.rfb.encoding.decoder.CursorPosDecoder;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.DesctopSizeDecoder;
import com.glavsoft.rfb.encoding.decoder.HextileDecoder;
import com.glavsoft.rfb.encoding.decoder.RREDecoder;
import com.glavsoft.rfb.encoding.decoder.RawDecoder;
import com.glavsoft.rfb.encoding.decoder.RichCursorDecoder;
import com.glavsoft.rfb.encoding.decoder.TightDecoder;
import com.glavsoft.rfb.encoding.decoder.ZRLEDecoder;
import com.glavsoft.rfb.encoding.decoder.ZlibDecoder;
import com.glavsoft.rfb.protocol.LocalPointer;
import com.glavsoft.rfb.protocol.MessageQueue;
import com.glavsoft.rfb.protocol.ProtocolContext;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.rfb.protocol.ReceiverTask;
import com.glavsoft.rfb.protocol.SenderTask;
import com.glavsoft.rfb.protocol.handlers.Handshaker;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import com.glavsoft.transport.BaudrateMeter;
import com.glavsoft.transport.Transport;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Protocol
implements IChangeSettingsListener {
    private final ProtocolContext context;
    private final Logger logger;
    private final IRequestString passwordRetriever;
    private MessageQueue messageQueue;
    private SenderTask senderTask;
    private ReceiverTask receiverTask;
    private IRfbSessionListener rfbSessionListener;
    private IRepaintController repaintController;
    private Thread senderThread;
    private Thread receiverThread;
    private PixelFormat serverPixelFormat;
    private final Map<EncodingType, Decoder> decoders = new LinkedHashMap<EncodingType, Decoder>();
    private final Set<ClientMessageType> clientMessageTypes = new HashSet<ClientMessageType>();
    private boolean inCleanUp = false;
    private boolean isMac;
    private BaudrateMeter baudrateMeter;
    private IRequestString connectionIdRetriever;

    public Protocol(Transport transport, IRequestString passwordRetriever, ProtocolSettings settings) {
        this.context = new ProtocolContext();
        this.context.transport = transport;
        this.passwordRetriever = passwordRetriever;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.context.settings = settings;
        this.decoders.put(EncodingType.RAW_ENCODING, RawDecoder.getInstance());
    }

    public void handshake() throws UnsupportedProtocolVersionException, UnsupportedSecurityTypeException, AuthenticationFailedException, TransportException, FatalException {
        this.context.transport = new Handshaker(this).handshake(this.getTransport());
        this.messageQueue = new MessageQueue();
    }

    public IRequestString getPasswordRetriever() {
        return this.passwordRetriever;
    }

    public void startNormalHandling(IRfbSessionListener rfbSessionListener, IRepaintController repaintController, ClipboardController clipboardController) {
        this.rfbSessionListener = rfbSessionListener;
        this.repaintController = repaintController;
        this.correctServerPixelFormat();
        this.context.setPixelFormat(this.createPixelFormat(this.context.settings));
        this.sendMessage(new SetPixelFormatMessage(this.context.pixelFormat));
        this.logger.fine("sent: " + this.context.pixelFormat);
        this.sendSupportedEncodingsMessage(this.context.settings);
        this.context.settings.addListener(this);
        this.context.settings.addListener(repaintController);
        this.sendRefreshMessage();
        this.senderTask = new SenderTask(this.messageQueue, this.context.transport, this);
        this.senderThread = new Thread((Runnable)this.senderTask, "RfbSenderTask");
        this.senderThread.start();
        this.resetDecoders();
        this.receiverTask = new ReceiverTask(this.context.transport, repaintController, clipboardController, this, this.baudrateMeter);
        this.receiverThread = new Thread((Runnable)this.receiverTask, "RfbReceiverTask");
        this.receiverThread.start();
    }

    private void correctServerPixelFormat() {
        if (0 == this.serverPixelFormat.trueColourFlag) {
            int depth = this.serverPixelFormat.depth;
            if (0 == depth) {
                depth = this.serverPixelFormat.bitsPerPixel;
            }
            if (0 == depth) {
                depth = 24;
            }
            this.serverPixelFormat = depth <= 3 ? PixelFormat.create3bitColorDepthPixelFormat(this.serverPixelFormat.bigEndianFlag) : (depth <= 6 ? PixelFormat.create6bitColorDepthPixelFormat(this.serverPixelFormat.bigEndianFlag) : (depth <= 8 ? PixelFormat.create8bitColorDepthBGRPixelFormat(this.serverPixelFormat.bigEndianFlag) : (depth <= 16 ? PixelFormat.create16bitColorDepthPixelFormat(this.serverPixelFormat.bigEndianFlag) : PixelFormat.create24bitColorDepthPixelFormat(this.serverPixelFormat.bigEndianFlag))));
        }
        long significant = this.serverPixelFormat.redMax << this.serverPixelFormat.redShift | this.serverPixelFormat.greenMax << this.serverPixelFormat.greenShift | this.serverPixelFormat.blueMax << this.serverPixelFormat.blueShift;
        if (32 == this.serverPixelFormat.bitsPerPixel && ((significant & 0xFF000000L) == 0L || (significant & 0xFFL) == 0L) && 32 == this.serverPixelFormat.depth) {
            this.serverPixelFormat.depth = (byte)24;
        }
    }

    public void sendMessage(ClientToServerMessage message) {
        this.messageQueue.put(message);
    }

    public void sendSupportedEncodingsMessage(ProtocolSettings settings) {
        LinkedHashSet<EncodingType> encodings = new LinkedHashSet<EncodingType>();
        EncodingType preferredEncoding = settings.getPreferredEncoding();
        if (preferredEncoding != EncodingType.RAW_ENCODING) {
            encodings.add(preferredEncoding);
        }
        block8: for (EncodingType e : this.decoders.keySet()) {
            if (e == preferredEncoding) continue;
            switch (e) {
                case RAW_ENCODING: {
                    continue block8;
                }
                case COMPRESS_LEVEL_0: {
                    int compressionLevel = settings.getCompressionLevel();
                    if (compressionLevel <= 0 || compressionLevel >= 10) continue block8;
                    encodings.add(EncodingType.byId(EncodingType.COMPRESS_LEVEL_0.getId() + compressionLevel));
                    continue block8;
                }
                case JPEG_QUALITY_LEVEL_0: {
                    int jpegQuality = settings.getJpegQuality();
                    int colorDepth = settings.getColorDepth();
                    if (jpegQuality <= 0 || jpegQuality >= 10 || colorDepth != 24 && colorDepth != 0) continue block8;
                    encodings.add(EncodingType.byId(EncodingType.JPEG_QUALITY_LEVEL_0.getId() + jpegQuality));
                    continue block8;
                }
                case COPY_RECT: {
                    if (!settings.isAllowCopyRect()) continue block8;
                    encodings.add(EncodingType.COPY_RECT);
                    continue block8;
                }
                case RICH_CURSOR: {
                    if (settings.getMouseCursorTrack() != LocalPointer.HIDE && settings.getMouseCursorTrack() != LocalPointer.ON) continue block8;
                    encodings.add(EncodingType.RICH_CURSOR);
                    continue block8;
                }
                case CURSOR_POS: {
                    if (settings.getMouseCursorTrack() != LocalPointer.HIDE && settings.getMouseCursorTrack() != LocalPointer.ON) continue block8;
                    encodings.add(EncodingType.CURSOR_POS);
                    continue block8;
                }
            }
            encodings.add(e);
        }
        SetEncodingsMessage encodingsMessage = new SetEncodingsMessage(encodings);
        this.sendMessage(encodingsMessage);
        this.logger.fine("sent: " + encodingsMessage.toString());
    }

    private PixelFormat createPixelFormat(ProtocolSettings settings) {
        byte serverBigEndianFlag = this.serverPixelFormat.bigEndianFlag;
        switch (settings.getColorDepth()) {
            case 24: {
                return PixelFormat.create24bitColorDepthPixelFormat(serverBigEndianFlag);
            }
            case 16: {
                return PixelFormat.create16bitColorDepthPixelFormat(serverBigEndianFlag);
            }
            case 8: {
                return this.hackForMacOsXScreenSharingServer(PixelFormat.create8bitColorDepthBGRPixelFormat(serverBigEndianFlag));
            }
            case 6: {
                return this.hackForMacOsXScreenSharingServer(PixelFormat.create6bitColorDepthPixelFormat(serverBigEndianFlag));
            }
            case 3: {
                return this.hackForMacOsXScreenSharingServer(PixelFormat.create3bitColorDepthPixelFormat(serverBigEndianFlag));
            }
            case 0: {
                return this.serverPixelFormat;
            }
        }
        return PixelFormat.create24bitColorDepthPixelFormat(serverBigEndianFlag);
    }

    private PixelFormat hackForMacOsXScreenSharingServer(PixelFormat pixelFormat) {
        if (this.isMac) {
            pixelFormat.depth = (byte)16;
            pixelFormat.bitsPerPixel = (byte)16;
        }
        return pixelFormat;
    }

    @Override
    public void settingsChanged(SettingsChangedEvent e) {
        ProtocolSettings settings = (ProtocolSettings)e.getSource();
        if (settings.isChangedEncodings()) {
            this.sendSupportedEncodingsMessage(settings);
        }
        if (settings.isChangedColorDepth() && this.receiverTask != null) {
            this.receiverTask.queueUpdatePixelFormat(this.createPixelFormat(settings));
        }
    }

    public void sendRefreshMessage() {
        this.sendMessage(new FramebufferUpdateRequestMessage(0, 0, this.context.fbWidth, this.context.fbHeight, false));
        this.logger.fine("sent: full FB Refresh");
    }

    public void sendFbUpdateMessage() {
        this.sendMessage(this.receiverTask.fullscreenFbUpdateIncrementalRequest);
    }

    public void cleanUpSession(String message) {
        this.cleanUpSession();
        this.rfbSessionListener.rfbSessionStopped(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpSession() {
        Protocol protocol = this;
        synchronized (protocol) {
            if (this.inCleanUp) {
                return;
            }
            this.inCleanUp = true;
        }
        if (this.senderTask != null && this.senderThread.isAlive()) {
            this.senderThread.interrupt();
        }
        if (this.receiverTask != null && this.receiverThread.isAlive()) {
            this.receiverThread.interrupt();
        }
        if (this.senderTask != null) {
            try {
                this.senderThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.senderTask = null;
        }
        if (this.receiverTask != null) {
            try {
                this.receiverThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.receiverTask = null;
        }
        protocol = this;
        synchronized (protocol) {
            this.inCleanUp = false;
        }
        ByteBuffer.removeInstance();
    }

    public void setServerPixelFormat(PixelFormat serverPixelFormat) {
        this.serverPixelFormat = serverPixelFormat;
    }

    public ProtocolSettings getSettings() {
        return this.context.getSettings();
    }

    public Transport getTransport() {
        return this.context.getTransport();
    }

    public int getFbWidth() {
        return this.context.getFbWidth();
    }

    public void setFbWidth(int frameBufferWidth) {
        this.context.setFbWidth(frameBufferWidth);
    }

    public int getFbHeight() {
        return this.context.getFbHeight();
    }

    public void setFbHeight(int frameBufferHeight) {
        this.context.setFbHeight(frameBufferHeight);
    }

    public PixelFormat getPixelFormat() {
        return this.context.getPixelFormat();
    }

    public void setPixelFormat(PixelFormat pixelFormat) {
        this.context.setPixelFormat(pixelFormat);
        if (this.repaintController != null) {
            this.repaintController.setPixelFormat(pixelFormat);
        }
    }

    public void setRemoteDesktopName(String name) {
        this.context.setRemoteDesktopName(name);
    }

    public String getRemoteDesktopName() {
        return this.context.getRemoteDesktopName();
    }

    public void setTight(boolean isTight) {
        this.context.setTight(isTight);
    }

    public boolean isTight() {
        return this.context.isTight();
    }

    public void setProtocolVersion(Handshaker.ProtocolVersion protocolVersion) {
        this.context.setProtocolVersion(protocolVersion);
    }

    public Handshaker.ProtocolVersion getProtocolVersion() {
        return this.context.getProtocolVersion();
    }

    public void registerRfbEncodings() {
        this.decoders.put(EncodingType.TIGHT, new TightDecoder());
        this.decoders.put(EncodingType.HEXTILE, new HextileDecoder());
        this.decoders.put(EncodingType.ZRLE, new ZRLEDecoder());
        this.decoders.put(EncodingType.ZLIB, new ZlibDecoder());
        this.decoders.put(EncodingType.RRE, new RREDecoder());
        this.decoders.put(EncodingType.COPY_RECT, new CopyRectDecoder());
        this.decoders.put(EncodingType.RICH_CURSOR, new RichCursorDecoder());
        this.decoders.put(EncodingType.DESKTOP_SIZE, new DesctopSizeDecoder());
        this.decoders.put(EncodingType.CURSOR_POS, new CursorPosDecoder());
    }

    public void resetDecoders() {
        for (Decoder decoder : this.decoders.values()) {
            if (decoder == null) continue;
            decoder.reset();
        }
    }

    public Decoder getDecoderByType(EncodingType type) {
        return this.decoders.get((Object)type);
    }

    public void registerEncoding(RfbCapabilityInfo capInfo) {
        try {
            Decoder decoder;
            EncodingType encodingType = EncodingType.byId(capInfo.getCode());
            if (!this.decoders.containsKey((Object)encodingType) && (decoder = encodingType.klass.newInstance()) != null) {
                this.decoders.put(encodingType, decoder);
                this.logger.finer("Register encoding: " + (Object)((Object)encodingType));
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.finer(e.getMessage());
        }
        catch (InstantiationException e) {
            this.logger.warning(e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.warning(e.getMessage());
        }
    }

    public void registerClientMessageType(RfbCapabilityInfo capInfo) {
        try {
            ClientMessageType clientMessageType = ClientMessageType.byId(capInfo.getCode());
            this.clientMessageTypes.add(clientMessageType);
            this.logger.finer("Register client message type: " + (Object)((Object)clientMessageType));
        }
        catch (IllegalArgumentException e) {
            this.logger.finer(e.getMessage());
        }
    }

    public boolean isSupported(ClientMessageType type) {
        return this.clientMessageTypes.contains((Object)type) || ClientMessageType.isStandardType(type);
    }

    public void setTunnelType(TunnelType tunnelType) {
        this.context.setTunnelType(tunnelType);
    }

    public TunnelType getTunnelType() {
        return this.context.getTunnelType();
    }

    public void setMac(boolean isMac) {
        this.isMac = isMac;
    }

    public void setBaudrateMeter(BaudrateMeter baudrateMeter) {
        this.baudrateMeter = baudrateMeter;
    }

    public int kBPS() {
        return this.baudrateMeter == null ? -1 : this.baudrateMeter.kBPS();
    }

    public boolean isMac() {
        return this.isMac;
    }

    public void setConnectionIdRetriever(IRequestString connectionIdRetriever) {
        this.connectionIdRetriever = connectionIdRetriever;
    }

    public IRequestString getConnectionIdRetriever() {
        return this.connectionIdRetriever;
    }
}

