/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer.swing.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

class StatusBar
extends JPanel {
    private JLabel messageLabel;

    StatusBar() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 23));
        this.messageLabel = new JLabel("");
        Font f = this.messageLabel.getFont();
        this.messageLabel.setFont(f.deriveFont(f.getStyle() & 0xFFFFFFFE));
        this.add((Component)this.messageLabel, "Center");
        JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.setOpaque(false);
        this.add((Component)rightPanel, "East");
        this.setBorder(new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color oldColor = g.getColor();
                g.translate(x, y);
                g.setColor(c.getBackground().darker());
                g.drawLine(0, 0, width - 1, 0);
                g.setColor(c.getBackground().brighter());
                g.drawLine(0, 1, width - 1, 1);
                g.translate(-x, -y);
                g.setColor(oldColor);
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(2, 2, 2, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }
        });
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }
}

