/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.viewer;

import com.glavsoft.exceptions.CommonException;
import com.glavsoft.rfb.protocol.ProtocolSettings;
import com.glavsoft.utils.LazyLoaded;
import com.glavsoft.utils.Strings;
import com.glavsoft.viewer.ParametersHandler;
import com.glavsoft.viewer.cli.Parser;
import com.glavsoft.viewer.mvp.View;
import com.glavsoft.viewer.settings.ConnectionParams;
import com.glavsoft.viewer.settings.UiSettings;
import com.glavsoft.viewer.swing.ConnectionPresenter;
import com.glavsoft.viewer.swing.MouseEnteredListener;
import com.glavsoft.viewer.swing.SwingConnectionWorkerFactory;
import com.glavsoft.viewer.swing.SwingViewerWindow;
import com.glavsoft.viewer.swing.SwingViewerWindowFactory;
import com.glavsoft.viewer.swing.ViewerEventsListener;
import com.glavsoft.viewer.swing.gui.ConnectionDialogView;
import com.glavsoft.viewer.swing.gui.ConnectionInfoView;
import com.glavsoft.viewer.swing.gui.ConnectionView;
import com.glavsoft.viewer.swing.mac.MacApplicationWrapper;
import com.glavsoft.viewer.swing.mac.MacUtils;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class Viewer
extends JApplet
implements Runnable,
MouseListener,
ViewerEventsListener {
    private static final String ATTR_APPLET_GOODBYE_URL = "AppletGoodbyeURL";
    private static final String DEFAULT_APPLET_GOODBYE_URL = "about:blank";
    private final ApplicationSettings applicationSettings;
    private static final Logger logger = Logger.getLogger(Viewer.class.getName());
    private int paramsMask;
    private boolean allowAppletInteractiveConnections;
    private final ConnectionParams connectionParams;
    private String passwordFromParams;
    private boolean isSeparateFrame = true;
    private boolean isApplet = true;
    private final ProtocolSettings settings;
    private final UiSettings uiSettings;
    private volatile boolean isAppletStopped = false;
    private ConnectionPresenter connectionPresenter;
    private MouseEnteredListener mouseEnteredListener;
    private static LazyLoaded<String> ver = new LazyLoaded<String>(new LazyLoaded.Loader<String>(){

        @Override
        public String load() {
            String version = Viewer.class.getPackage().getImplementationVersion();
            if (version != null) {
                return version;
            }
            try {
                String result;
                Attributes attrs = new Manifest(new FileInputStream("META-INF/MANIFEST.MF")).getMainAttributes();
                String ver = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                try {
                    result = ver != null ? new String(ver.getBytes("ISO-8859-1"), "ISO-8859-1") : null;
                }
                catch (UnsupportedEncodingException e) {
                    result = null;
                }
                version = result;
            }
            catch (FileNotFoundException e) {
                System.out.println("Manifest file not found");
            }
            catch (IOException e) {
                System.out.println("Cannot read Manifest file");
            }
            return version;
        }
    });

    public static void main(String[] args) {
        if (MacUtils.isMac()) {
            try {
                MacApplicationWrapper application = MacApplicationWrapper.getApplication();
                application.setEnabledAboutMenu(false);
                MacUtils.setName("TightVNC Viewer");
                application.setDockIconImage(MacUtils.getIconImage());
            }
            catch (CommonException e) {
                logger.warning(e.getMessage());
            }
        }
        Parser parser = new Parser();
        ParametersHandler.completeParserOptions(parser);
        parser.parse(args);
        if (parser.isSet("help")) {
            Viewer.printUsage(parser.optionsUsage());
            System.exit(0);
        }
        Viewer viewer = new Viewer(parser);
        SwingUtilities.invokeLater(viewer);
    }

    private static void printUsage(String additional) {
        System.out.println("Usage: java -jar (progfilename) [hostname [port_number]] [Options]\n    or\n java -jar (progfilename) [Options]\n    or\n java -jar (progfilename) -help\n    to view this help\n\nWhere Options are:\n" + additional + "\nOptions format: -optionName=optionValue. Ex. -host=localhost -port=5900 -viewonly=yes\nBoth option name and option value are case insensitive.");
    }

    public Viewer() {
        logger.info("TightVNC Viewer version " + Viewer.ver());
        this.connectionParams = new ConnectionParams();
        this.settings = ProtocolSettings.getDefaultSettings();
        this.uiSettings = new UiSettings();
        this.applicationSettings = new ApplicationSettings();
    }

    private Viewer(Parser parser) {
        this();
        this.paramsMask = ParametersHandler.completeSettingsFromCLI(parser, this.connectionParams, this.settings, this.uiSettings, this.applicationSettings);
        this.setLoggingLevel(this.applicationSettings.logLevel);
        this.passwordFromParams = this.applicationSettings.password;
        this.isApplet = false;
    }

    private void setLoggingLevel(Level levelToSet) {
        Logger appLogger = Logger.getLogger("com.glavsoft");
        try {
            appLogger.setUseParentHandlers(false);
            appLogger.setLevel(levelToSet);
            for (Handler h : appLogger.getHandlers()) {
                if (h instanceof ConsoleHandler) {
                    appLogger.removeHandler(h);
                    continue;
                }
                h.setLevel(levelToSet);
            }
            ConsoleHandler ch = new ConsoleHandler();
            ch.setLevel(levelToSet);
            appLogger.addHandler(ch);
        }
        catch (SecurityException e) {
            logger.warning("cannot set logging level to: " + levelToSet);
        }
    }

    private void closeApp() {
        if (this.connectionPresenter != null) {
            this.connectionPresenter.cancelConnection();
            logger.info("Connection cancelled.");
        }
        if (this.isApplet) {
            logger.severe("Applet is stopped.");
            this.isAppletStopped = true;
            this.repaint();
            this.stop();
            URL goodbyeUrl = null;
            String goodBye = this.getParameter(ATTR_APPLET_GOODBYE_URL);
            if (Strings.isTrimmedEmpty(goodBye)) {
                return;
            }
            try {
                goodbyeUrl = new URL(goodBye);
            }
            catch (MalformedURLException e) {
                logger.severe("Malformed URL: '" + goodBye + "'. Using '" + DEFAULT_APPLET_GOODBYE_URL + "'");
                try {
                    goodbyeUrl = new URL(DEFAULT_APPLET_GOODBYE_URL);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.getAppletContext().showDocument(goodbyeUrl);
        } else {
            System.exit(0);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isAppletStopped) {
            super.paint(g);
        } else {
            this.getContentPane().removeAll();
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawString("Disconnected", 10, 20);
        }
    }

    @Override
    public void destroy() {
        this.closeApp();
        super.destroy();
    }

    @Override
    public void init() {
        AppletSettings appletSettings = new AppletSettings();
        this.paramsMask = ParametersHandler.completeSettingsFromApplet(this, this.connectionParams, this.settings, this.uiSettings, this.applicationSettings, appletSettings);
        this.setLoggingLevel(this.applicationSettings.logLevel);
        this.isSeparateFrame = appletSettings.isSeparateFrame;
        this.passwordFromParams = this.applicationSettings.password;
        this.isApplet = true;
        this.allowAppletInteractiveConnections = appletSettings.allowInteractiveConnections;
        this.repaint();
        try {
            SwingUtilities.invokeAndWait(this);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
        }
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void run() {
        if (this.isApplet && this.allowAppletInteractiveConnections) {
            this.uiSettings.showConnectionDialog = true;
        }
        if (this.isApplet && !this.allowAppletInteractiveConnections) {
            this.uiSettings.showConnectionDialog = false;
        }
        this.connectionPresenter = new ConnectionPresenter();
        this.connectionPresenter.addModel("ConnectionParamsModel", this.connectionParams);
        ConnectionView connectionView = (ConnectionView)((Object)(this.uiSettings.showConnectionDialog ? new ConnectionDialogView(this, this.connectionPresenter) : new ConnectionInfoView(this, this.connectionPresenter)));
        this.connectionPresenter.addView("ConnectionView", connectionView);
        if (this.isApplet) {
            this.connectionPresenter.addView("AppletStatusStringView", new AppletStatusStringView());
        }
        SwingViewerWindowFactory viewerWindowFactory = new SwingViewerWindowFactory(this.isSeparateFrame, this);
        viewerWindowFactory.setAppName("TightVNC Viewer v." + Viewer.ver());
        if (this.isApplet) {
            viewerWindowFactory.setIsApplet(true);
            viewerWindowFactory.setExternalContainer(this);
        }
        this.connectionPresenter.setConnectionWorkerFactory(new SwingConnectionWorkerFactory(connectionView.getFrame(), this.passwordFromParams, this.connectionPresenter, viewerWindowFactory));
        this.connectionPresenter.startConnection(this.settings, this.uiSettings, this.paramsMask);
    }

    public static String ver() {
        return ver.get();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mouseEnteredListener != null) {
            this.mouseEnteredListener.mouseEnteredEvent(mouseEvent);
        }
    }

    @Override
    public void onViewerComponentClosing() {
        this.closeApp();
    }

    @Override
    public void onViewerComponentContainerBuilt(SwingViewerWindow viewerWindow) {
        if (this.isSeparateFrame) {
            viewerWindow.setVisible();
        }
        viewerWindow.validate();
        this.mouseEnteredListener = viewerWindow;
        viewerWindow.addMouseListener(this);
    }

    private void moveFrameToFrontABitLater(final JFrame frame) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.toFront();
                    }
                });
            }
        }).start();
    }

    public static class ApplicationSettings {
        Level logLevel;
        public String password;

        public void calculateLogLevel(boolean verbose, boolean verboseMore) {
            this.logLevel = verboseMore ? Level.FINER : (verbose ? Level.FINE : Level.INFO);
        }
    }

    public static class AppletSettings {
        public boolean allowInteractiveConnections;
        public boolean isSeparateFrame;
    }

    private class AppletStatusStringView
    implements View {
        private AppletStatusStringView() {
        }

        @Override
        public void showView() {
        }

        @Override
        public void closeView() {
        }

        public void setMessage(String message) {
            Viewer.this.getAppletContext().showStatus(message);
        }
    }
}

