/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.handlers;

import com.glavsoft.exceptions.AuthenticationFailedException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.exceptions.UnsupportedProtocolVersionException;
import com.glavsoft.exceptions.UnsupportedSecurityTypeException;
import com.glavsoft.rfb.IRequestString;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.auth.AuthHandler;
import com.glavsoft.rfb.protocol.auth.NoneAuthentication;
import com.glavsoft.rfb.protocol.auth.SecurityType;
import com.glavsoft.rfb.protocol.auth.TightAuthentication;
import com.glavsoft.rfb.protocol.auth.VncAuthentication;
import com.glavsoft.rfb.protocol.tunnel.SslTunnel;
import com.glavsoft.rfb.protocol.tunnel.TunnelType;
import com.glavsoft.transport.Transport;
import com.glavsoft.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Handshaker {
    private static final int PROTOCOL_STRING_LENGTH = 12;
    private static final String RFB_PROTOCOL_STRING_REGEXP = "^RFB (\\d\\d\\d).(\\d\\d\\d)\n$";
    private static final String DISPATCHER_PROTOCOL_STRING = "TCPDISPATCH\n";
    private static final int MIN_SUPPORTED_VERSION_MAJOR = 3;
    private static final int MIN_SUPPORTED_VERSION_MINOR = 3;
    private static final int MAX_SUPPORTED_VERSION_MAJOR = 3;
    private static final int MAX_SUPPORTED_VERSION_MINOR = 8;
    protected static final int DISPATCHER_PROTOCOL_VERSION = 3;
    protected static final int KEEP_ALIVE_BYTE = 0;
    protected static final int START_BYTE = 1;
    private Protocol protocol;
    private Logger logger;
    private final Map<Integer, AuthHandler> registeredAuthHandlers = new HashMap<Integer, AuthHandler>();

    public Handshaker(Protocol protocol) {
        this.protocol = protocol;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.registerAuthHandler(SecurityType.NONE_AUTHENTICATION.getId(), new NoneAuthentication());
        this.registerAuthHandler(SecurityType.VNC_AUTHENTICATION.getId(), new VncAuthentication());
        TightAuthentication tightAuthentication = new TightAuthentication();
        tightAuthentication.registerAuthHandler(new NoneAuthentication());
        tightAuthentication.registerAuthHandler(new VncAuthentication());
        if (protocol.getSettings().getTunnelType() != TunnelType.NOTUNNEL && SslTunnel.isTransportAvailable()) {
            tightAuthentication.registerTunnelingHandler(new SslTunnel());
            this.registerAuthHandler(SecurityType.TIGHT2_AUTHENTICATION.getId(), tightAuthentication);
        }
        this.registerAuthHandler(SecurityType.TIGHT_AUTHENTICATION.getId(), tightAuthentication);
    }

    public Transport handshake(Transport transport) throws TransportException, UnsupportedProtocolVersionException, AuthenticationFailedException, FatalException, UnsupportedSecurityTypeException {
        String protocolString = transport.readString(12);
        if (this.isDispatcherConnection(protocolString)) {
            this.handshakeToDispatcher(transport);
            protocolString = transport.readString(12);
        }
        ProtocolVersion ver = this.matchProtocolVersion(protocolString);
        transport.write(Strings.getBytesWithCharset("RFB 00" + ver.major + ".00" + ver.minor + "\n", Transport.ISO_8859_1)).flush();
        this.protocol.setProtocolVersion(ver);
        this.logger.info("Set protocol version to: " + (Object)((Object)ver));
        transport = this.auth(transport, ver);
        return transport;
    }

    private void handshakeToDispatcher(Transport transport) throws TransportException, UnsupportedProtocolVersionException, AuthenticationFailedException {
        byte b;
        int numSupportedVersions = transport.readUInt8();
        ArrayList<Integer> remoteVersions = new ArrayList<Integer>(numSupportedVersions);
        for (int i = 0; i < numSupportedVersions; ++i) {
            remoteVersions.add(transport.readUInt8());
        }
        this.logger.fine("Dispatcher protocol versions: " + Arrays.toString(remoteVersions.toArray()));
        if (!remoteVersions.contains(3)) {
            throw new UnsupportedProtocolVersionException("Dispatcher unsupported protocol versions");
        }
        transport.writeByte(3);
        transport.writeByte(1).flush();
        long connectionId = 0L;
        IRequestString connIdRetriever = this.protocol.getConnectionIdRetriever();
        if (null == connIdRetriever) {
            throw new IllegalStateException("ConnectionIdRetriever is null");
        }
        String sId = connIdRetriever.getResult();
        if (Strings.isTrimmedEmpty(sId)) {
            throw new AuthenticationFailedException("ConnectionId is empty");
        }
        try {
            connectionId = Long.parseLong(sId);
        }
        catch (NumberFormatException nfe) {
            throw new AuthenticationFailedException("Wrong ConnectionId");
        }
        if (0L == connectionId) {
            throw new AuthenticationFailedException("ConnectionId have not be equals to zero");
        }
        transport.writeUInt32(connectionId).flush();
        transport.writeByte(0);
        transport.writeByte(0).flush();
        int tokenLength = transport.readUInt8();
        byte[] token = transport.readBytes(tokenLength);
        do {
            if (0 != (b = transport.readByte())) continue;
            this.logger.finer("keep-alive");
            transport.writeByte(0).flush();
        } while (b != 1);
        this.logger.info("Dispatcher handshake completed");
    }

    private boolean isDispatcherConnection(String protocolString) {
        boolean dispatcherDetected = DISPATCHER_PROTOCOL_STRING.equals(protocolString);
        if (dispatcherDetected) {
            this.logger.info("Dispatcher connection detected");
        }
        return dispatcherDetected;
    }

    private ProtocolVersion matchProtocolVersion(String protocolString) throws UnsupportedProtocolVersionException {
        ProtocolVersion ver;
        this.logger.info("Server protocol string: " + protocolString.substring(0, protocolString.length() - 1));
        Pattern pattern = Pattern.compile(RFB_PROTOCOL_STRING_REGEXP);
        Matcher matcher = pattern.matcher(protocolString);
        if (!matcher.matches()) {
            throw new UnsupportedProtocolVersionException("Unsupported protocol version: " + protocolString);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        boolean isMac = false;
        if (889 == minor) {
            isMac = true;
        }
        if (major < 3 || 3 == major && minor < 3) {
            throw new UnsupportedProtocolVersionException("Unsupported protocol version: " + major + "." + minor);
        }
        if (major > 3) {
            minor = 8;
        }
        if (minor >= 3 && minor < 7) {
            ver = ProtocolVersion.PROTOCOL_VERSION_3_3;
        } else if (7 == minor) {
            ver = ProtocolVersion.PROTOCOL_VERSION_3_7;
        } else if (minor >= 8) {
            ver = ProtocolVersion.PROTOCOL_VERSION_3_8;
        } else {
            throw new UnsupportedProtocolVersionException("Unsupported protocol version: " + protocolString);
        }
        this.protocol.setMac(isMac);
        return ver;
    }

    private Transport auth(Transport transport, ProtocolVersion ver) throws UnsupportedSecurityTypeException, TransportException, FatalException, AuthenticationFailedException {
        AuthHandler handler;
        switch (ver) {
            case PROTOCOL_VERSION_3_3: {
                handler = this.auth33(transport);
                break;
            }
            case PROTOCOL_VERSION_3_7: {
                handler = this.auth37_38(transport);
                break;
            }
            case PROTOCOL_VERSION_3_8: {
                handler = this.auth37_38(transport);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        transport = handler.authenticate(transport, this.protocol);
        if (ver == ProtocolVersion.PROTOCOL_VERSION_3_8 || handler.getType() != SecurityType.NONE_AUTHENTICATION) {
            handler.checkSecurityResult(transport);
        }
        handler.initProcedure(transport, this.protocol);
        return transport;
    }

    private AuthHandler auth33(Transport transport) throws TransportException, UnsupportedSecurityTypeException {
        int type = transport.readInt32();
        this.logger.info("Type received: " + type);
        if (0 == type) {
            throw new UnsupportedSecurityTypeException(transport.readString());
        }
        AuthHandler handler = this.registeredAuthHandlers.get(this.selectAuthHandlerId((byte)(0xFF & type)));
        return handler;
    }

    private AuthHandler auth37_38(Transport transport) throws TransportException, UnsupportedSecurityTypeException {
        int secTypesNum = transport.readUInt8();
        if (0 == secTypesNum) {
            throw new UnsupportedSecurityTypeException(transport.readString());
        }
        byte[] secTypes = transport.readBytes(secTypesNum);
        this.logger.info("Security Types received (" + secTypesNum + "): " + Strings.toString(secTypes));
        int typeIdAccepted = this.selectAuthHandlerId(secTypes);
        AuthHandler authHandler = this.registeredAuthHandlers.get(typeIdAccepted);
        transport.writeByte(typeIdAccepted).flush();
        return authHandler;
    }

    private int selectAuthHandlerId(byte ... secTypes) throws UnsupportedSecurityTypeException, TransportException {
        AuthHandler handler;
        for (byte type : secTypes) {
            if (SecurityType.TIGHT2_AUTHENTICATION.getId() != (0xFF & type) || (handler = this.registeredAuthHandlers.get(SecurityType.TIGHT2_AUTHENTICATION.getId())) == null) continue;
            this.logger.info("Security Type accepted: " + SecurityType.TIGHT2_AUTHENTICATION.name());
            return SecurityType.TIGHT2_AUTHENTICATION.getId();
        }
        for (byte type : secTypes) {
            if (SecurityType.TIGHT_AUTHENTICATION.getId() != (0xFF & type) || (handler = this.registeredAuthHandlers.get(SecurityType.TIGHT_AUTHENTICATION.getId())) == null) continue;
            this.logger.info("Security Type accepted: " + SecurityType.TIGHT_AUTHENTICATION.name());
            return SecurityType.TIGHT_AUTHENTICATION.getId();
        }
        for (byte type : secTypes) {
            handler = this.registeredAuthHandlers.get(0xFF & type);
            if (handler == null) continue;
            this.logger.info("Security Type accepted: " + (Object)((Object)handler.getType()));
            return handler.getType().getId();
        }
        throw new UnsupportedSecurityTypeException("No security types supported. Server sent '" + Strings.toString(secTypes) + "' security types, but we do not support any of their.");
    }

    private void registerAuthHandler(int id, AuthHandler handler) {
        this.registeredAuthHandlers.put(id, handler);
    }

    public static enum ProtocolVersion {
        PROTOCOL_VERSION_3_3(3, 3),
        PROTOCOL_VERSION_3_7(3, 7),
        PROTOCOL_VERSION_3_8(3, 8);

        public final int minor;
        public final int major;

        private ProtocolVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public String toString() {
            return String.valueOf(this.major) + "." + String.valueOf(this.minor);
        }
    }
}

