/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.rfb.protocol.MessageQueue;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.transport.Transport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;

public class SenderTask
implements Runnable {
    private final MessageQueue queue;
    private final Transport transport;
    private final Protocol protocol;

    public SenderTask(MessageQueue messageQueue, Transport transport, Protocol protocol) {
        this.queue = messageQueue;
        this.transport = transport;
        this.protocol = protocol;
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                ClientToServerMessage message = this.queue.get();
                if (message == null) continue;
                message.send(this.transport);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (TransportException e) {
            Logger.getLogger(this.getClass().getName()).severe("Close session: " + e.getMessage());
            this.protocol.cleanUpSession("Connection closed");
        }
        catch (Throwable te) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            te.printStackTrace(pw);
            this.protocol.cleanUpSession(te.getMessage() + "\n" + sw.toString());
        }
        Logger.getLogger(this.getClass().getName()).finer("Sender task stopped");
    }
}

