/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.function;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import com.sun.pdfview.function.PDFFunction;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;

public class FunctionType4
extends PDFFunction {
    private static HashSet<Operation> operationSet = null;
    private LinkedList tokens = new LinkedList();
    private LinkedList<Object> stack = new LinkedList();

    protected FunctionType4() {
        super(4);
        if (operationSet == null) {
            this.initOperations();
        }
    }

    private void initOperations() {
        if (operationSet == null) {
            operationSet = new HashSet();
            operationSet.add(new Operation("abs"){

                void eval() {
                    FunctionType4.this.pushDouble(Math.abs(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("add"){

                void eval() {
                    FunctionType4.this.pushDouble(FunctionType4.this.popDouble() + FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("atan"){

                void eval() {
                    double den = FunctionType4.this.popDouble();
                    double num = FunctionType4.this.popDouble();
                    if (den == 0.0) {
                        FunctionType4.this.pushDouble(90.0);
                    } else {
                        FunctionType4.this.pushDouble(Math.toDegrees(Math.atan(num / den)));
                    }
                }
            });
            operationSet.add(new Operation("ceiling"){

                void eval() {
                    FunctionType4.this.pushDouble(Math.ceil(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("cvi"){

                void eval() {
                    FunctionType4.this.pushDouble((int)FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("cvr"){

                void eval() {
                }
            });
            operationSet.add(new Operation("div"){

                void eval() {
                    double num2 = FunctionType4.this.popDouble();
                    double num1 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble(num1 / num2);
                }
            });
            operationSet.add(new Operation("exp"){

                void eval() {
                    double exponent = FunctionType4.this.popDouble();
                    double base = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble(Math.pow(exponent, base));
                }
            });
            operationSet.add(new Operation("floor"){

                void eval() {
                    FunctionType4.this.pushDouble(Math.floor(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("idiv"){

                void eval() {
                    long int2 = FunctionType4.this.popLong();
                    long int1 = FunctionType4.this.popLong();
                    FunctionType4.this.pushLong(int1 / int2);
                }
            });
            operationSet.add(new Operation("ln"){

                void eval() {
                    FunctionType4.this.pushDouble(Math.log(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("log"){

                void eval() {
                    FunctionType4.this.pushDouble(Math.log10(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("mod"){

                void eval() {
                    long int2 = FunctionType4.this.popLong();
                    long int1 = FunctionType4.this.popLong();
                    FunctionType4.this.pushLong(int1 % int2);
                }
            });
            operationSet.add(new Operation("mul"){

                void eval() {
                    FunctionType4.this.pushDouble(FunctionType4.this.popDouble() * FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("neg"){

                void eval() {
                    FunctionType4.this.pushDouble(-FunctionType4.this.popDouble());
                }
            });
            operationSet.add(new Operation("round"){

                void eval() {
                    FunctionType4.this.pushLong(Math.round(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("sin"){

                void eval() {
                    double radians = Math.toRadians(FunctionType4.this.popDouble());
                    FunctionType4.this.pushDouble(Math.toDegrees(Math.sin(radians)));
                }
            });
            operationSet.add(new Operation("sqrt"){

                void eval() {
                    FunctionType4.this.pushDouble(Math.sqrt(FunctionType4.this.popDouble()));
                }
            });
            operationSet.add(new Operation("sub"){

                void eval() {
                    double num2 = FunctionType4.this.popDouble();
                    double num1 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble(num1 - num2);
                }
            });
            operationSet.add(new Operation("truncate"){

                void eval() {
                    double num1 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushDouble((double)((long)num1) - num1);
                }
            });
            operationSet.add(new Operation("and"){

                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() & FunctionType4.this.popLong());
                }
            });
            operationSet.add(new Operation("bitshift"){

                void eval() {
                    long shift = FunctionType4.this.popLong();
                    long int1 = FunctionType4.this.popLong();
                    FunctionType4.this.pushLong(int1 << (int)shift);
                }
            });
            operationSet.add(new Operation("eq"){

                void eval() {
                    FunctionType4.this.pushBoolean(FunctionType4.this.popObject().equals(FunctionType4.this.popObject()));
                }
            });
            operationSet.add(new Operation("false"){

                void eval() {
                    FunctionType4.this.pushBoolean(false);
                }
            });
            operationSet.add(new Operation("ge"){

                void eval() {
                    double num2 = FunctionType4.this.popDouble();
                    double num1 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(num1 >= num2);
                }
            });
            operationSet.add(new Operation("gt"){

                void eval() {
                    double num2 = FunctionType4.this.popDouble();
                    double num1 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(num1 > num2);
                }
            });
            operationSet.add(new Operation("le"){

                void eval() {
                    double num2 = FunctionType4.this.popDouble();
                    double num1 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(num1 <= num2);
                }
            });
            operationSet.add(new Operation("lt"){

                void eval() {
                    double num2 = FunctionType4.this.popDouble();
                    double num1 = FunctionType4.this.popDouble();
                    FunctionType4.this.pushBoolean(num1 < num2);
                }
            });
            operationSet.add(new Operation("ne"){

                void eval() {
                    FunctionType4.this.pushBoolean(!FunctionType4.this.popObject().equals(FunctionType4.this.popObject()));
                }
            });
            operationSet.add(new Operation("not"){

                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() ^ 0xFFFFFFFFFFFFFFFFL);
                }
            });
            operationSet.add(new Operation("or"){

                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() | FunctionType4.this.popLong());
                }
            });
            operationSet.add(new Operation("true"){

                void eval() {
                    FunctionType4.this.pushBoolean(true);
                }
            });
            operationSet.add(new Operation("xor"){

                void eval() {
                    FunctionType4.this.pushLong(FunctionType4.this.popLong() ^ FunctionType4.this.popLong());
                }
            });
            operationSet.add(new Operation("if"){

                void eval() {
                    if (FunctionType4.this.popBoolean()) {
                        FunctionType4.this.stack.addFirst(FunctionType4.this.popExpression());
                    } else {
                        FunctionType4.this.popExpression();
                    }
                }
            });
            operationSet.add(new Operation("ifelse"){

                void eval() {
                    if (FunctionType4.this.popBoolean()) {
                        FunctionType4.this.popExpression();
                    } else {
                        FunctionType4.this.popExpression();
                    }
                }
            });
            operationSet.add(new Operation("copy"){

                void eval() {
                    long count = FunctionType4.this.popLong();
                    Object obj = FunctionType4.this.stack.removeFirst();
                    FunctionType4.this.stack.addFirst(obj);
                    FunctionType4.this.stack.addFirst(obj);
                }
            });
            operationSet.add(new Operation("dup"){

                void eval() {
                    Object obj = FunctionType4.this.popObject();
                    FunctionType4.this.pushObject(obj);
                    FunctionType4.this.pushObject(obj);
                }
            });
            operationSet.add(new Operation("exch"){

                void eval() {
                    Object any1 = FunctionType4.this.popObject();
                    Object any2 = FunctionType4.this.popObject();
                    FunctionType4.this.pushObject(any2);
                    FunctionType4.this.pushObject(any1);
                }
            });
            operationSet.add(new Operation("index"){

                void eval() {
                    Object obj = FunctionType4.this.stack.removeFirst();
                    FunctionType4.this.stack.addFirst(obj);
                    FunctionType4.this.stack.addFirst(obj);
                }
            });
            operationSet.add(new Operation("pop"){

                void eval() {
                    FunctionType4.this.stack.removeFirst();
                }
            });
            operationSet.add(new Operation("roll"){

                void eval() {
                    Object obj = FunctionType4.this.stack.removeFirst();
                    FunctionType4.this.stack.addFirst(obj);
                    FunctionType4.this.stack.addFirst(obj);
                }
            });
        }
    }

    protected void parse(PDFObject obj) throws IOException {
        this.readPS(obj.getStreamBuffer());
        throw new PDFParseException("Unsupported function type 4.");
    }

    protected void doFunction(float[] inputs, int inputOffset, float[] outputs, int outputOffset) {
    }

    private boolean popBoolean() {
        return false;
    }

    private void pushBoolean(boolean arg) {
    }

    private double popDouble() {
        return 0.0;
    }

    private void pushDouble(double arg) {
    }

    private Expression popExpression() {
        return null;
    }

    private void pushExpression(Expression expresson) {
    }

    private long popLong() {
        return 0L;
    }

    private void pushLong(long arg) {
    }

    private Object popObject() {
        return this.stack.removeFirst();
    }

    private void pushObject(Object obj) {
        this.stack.addFirst(obj);
    }

    private void readPS(ByteBuffer buf) {
    }

    abstract class Operation {
        private String operatorName;

        public Operation(String operatorName) {
            if (operatorName == null) {
                throw new RuntimeException("Cannot have a null operator name");
            }
            this.operatorName = operatorName;
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        abstract void eval();

        public boolean equals(Object obj) {
            if (obj instanceof Operation) {
                return ((Operation)obj).operatorName.equals(this.operatorName);
            }
            if (obj instanceof String) {
                return this.operatorName.equals(obj);
            }
            return false;
        }
    }

    class Expression
    extends LinkedList {
        Expression() {
        }

        public boolean equals(Object obj) {
            return obj instanceof Expression;
        }
    }
}

