/*
 * Decompiled with CFR 0.152.
 */
package calebe.model;

import calebe.Calebe;
import calebe.Principal;
import calebe.model.Comunicador;
import calebe.model.MyCallback;
import calebe.model.Update;
import calebe.model.cURL;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class Funcoes {
    private static HashMap config = new HashMap<String, Object>(){
        {
            this.put("urlSocket", "http://sic7.com.br:3000/");
        }
    };
    private static boolean MANTER_IMPRESSAO_ERRO = false;

    public static boolean isWindows() {
        Properties properties = System.getProperties();
        return String.valueOf(properties.getProperty("os.name")).toUpperCase().indexOf("WINDOWS") >= 0;
    }

    public static boolean isMAC() {
        Properties properties = System.getProperties();
        return String.valueOf(properties.getProperty("os.name")).toUpperCase().indexOf("MAC") >= 0;
    }

    public static String command(String command) {
        try {
            Process exec = Runtime.getRuntime().exec(command);
            InputStream in = exec.getInputStream();
            Scanner scan = new Scanner(in);
            String ret = "";
            while (scan.hasNext()) {
                ret = ret + scan.nextLine().toString() + "\n";
            }
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getIPLocal() {
        String ip = "";
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(Funcoes.class.getName()).log(Level.SEVERE, null, ex);
        }
        return ip;
    }

    public static ArrayList<HashMap> getInterfaces() {
        ArrayList<HashMap> interfaces = new ArrayList<HashMap>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                final NetworkInterface ni = networkInterfaces.nextElement();
                byte[] hardwareAddress = ni.getHardwareAddress();
                if (hardwareAddress == null) continue;
                final String[] hexadecimalFormat = new String[hardwareAddress.length];
                for (int i = 0; i < hardwareAddress.length; ++i) {
                    hexadecimalFormat[i] = String.format("%02X", hardwareAddress[i]);
                }
                interfaces.add(new HashMap(){
                    {
                        this.put("interface", ni.getDisplayName());
                        this.put("MAC", String.join((CharSequence)":", hexadecimalFormat));
                        this.put("ip", ni.getInterfaceAddresses().get(ni.getInterfaceAddresses().size() - 1));
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return interfaces;
    }

    public static String getIPExterno() {
        String ip = "";
        cURL curl = new cURL();
        ip = curl.exec("https://sic7.com.br/checkip.php?soip=1").trim();
        return ip;
    }

    public static String getHostName() {
        String host = "";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(Funcoes.class.getName()).log(Level.SEVERE, null, ex);
        }
        return host;
    }

    public static Object getConfig(String a) {
        return config.get(a);
    }

    public static HashMap<String, Object> jsonToHashMap(String dados) {
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        try {
            JSONObject json = new JSONObject(dados);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                retorno.put(key, json.get(key).toString());
            }
        }
        catch (JSONException ex) {
            Logger.getLogger(Funcoes.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retorno;
    }

    public static JSONObject hashMapToJson(HashMap<String, Object> disp) {
        JSONObject json = new JSONObject();
        Iterator<Map.Entry<String, Object>> keys = disp.entrySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next().getKey();
            try {
                json.put(key, disp.get(key));
            }
            catch (JSONException ex) {
                Logger.getLogger(Funcoes.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return json;
    }

    public static void deletarArquivo(String arquivo) {
        if (Funcoes.isFile(arquivo)) {
            File f = new File(arquivo);
            if (f.exists()) {
                f.delete();
            }
        } else if (Funcoes.isDirectory(arquivo)) {
            File f = new File(arquivo);
            Funcoes.remover(f);
        }
    }

    public static void remover(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Funcoes.remover(files[i]);
            }
        }
        f.delete();
    }

    public static boolean isFile(String arquivo) {
        File f = new File(arquivo);
        return f.exists();
    }

    public static boolean isDirectory(String arquivo) {
        File f = new File(arquivo);
        return f.isDirectory();
    }

    public static void file_put_contents(String filename, String texto) {
        try {
            String filenameTmp = filename + ".tmp";
            Funcoes.deletarArquivo(filename);
            Funcoes.deletarArquivo(filenameTmp);
            FileWriter arq = new FileWriter(filenameTmp);
            PrintWriter gravarArq = new PrintWriter(arq);
            gravarArq.printf(texto, new Object[0]);
            arq.close();
            File arquivo = new File(filenameTmp);
            arquivo.renameTo(new File(filename));
        }
        catch (IOException ex) {
            Logger.getLogger(Funcoes.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String file_get_contents(String filename) {
        String ret;
        block16: {
            ret = "-1";
            String CRLF = "\r\n";
            try {
                File f = new File(filename);
                if (!f.exists()) {
                    ret = "-2";
                    break block16;
                }
                try (BufferedReader br = new BufferedReader(new FileReader(f));){
                    StringBuilder sb = new StringBuilder();
                    while (br.ready()) {
                        sb.append(br.readLine()).append(CRLF);
                    }
                    ret = sb.toString();
                }
            }
            catch (IOException ex) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
                ret = "-3";
            }
        }
        return ret;
    }

    public static void copyDirectoryCompatibityMode(String origem, String destino) throws IOException {
        File source = new File(origem);
        File destination = new File(destino);
        Funcoes.copyDirectoryCompatibityMode(source, destination);
    }

    public static void copyDirectoryCompatibityMode(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            Funcoes.copyDirectory(source, destination);
        } else {
            Funcoes.copyFile(source, destination);
        }
    }

    private static void copyFile(File sourceFile, File destinationFile) throws IOException {
        if (destinationFile.exists()) {
            destinationFile.delete();
        }
        try (FileInputStream in = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(destinationFile);){
            int length;
            byte[] buf = new byte[1024];
            while ((length = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, length);
            }
        }
    }

    private static void copyDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdir();
        }
        for (String f : sourceDirectory.list()) {
            Funcoes.copyDirectoryCompatibityMode(new File(sourceDirectory, f), new File(destinationDirectory, f));
        }
    }

    public static boolean download(String origem, String destino) {
        boolean ret = true;
        try {
            Funcoes.deletarArquivo(destino);
            try {
                URL url = new URL(origem);
                File file = new File(destino);
                InputStream is = url.openStream();
                FileOutputStream fos = new FileOutputStream(file);
                int bytes = 0;
                while ((bytes = is.read()) != -1) {
                    fos.write(bytes);
                }
                is.close();
                fos.close();
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                ret = false;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                ret = false;
            }
            catch (IOException ex) {
                Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
                ret = false;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Update.class.getName()).log(Level.SEVERE, null, ex);
            ex.printStackTrace();
            ret = false;
        }
        return ret;
    }

    public static void unzipFolder(Path source, Path target) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(source.toFile()));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = false;
                if (zipEntry.getName().endsWith(File.separator) || zipEntry.isDirectory()) {
                    isDirectory = true;
                }
                System.out.print(zipEntry.getName());
                System.out.print(" size: ");
                System.out.print(zipEntry.getSize());
                System.out.print(" isDirectory: ");
                System.out.print(zipEntry.isDirectory());
                System.out.print(" directory: ");
                System.out.print(isDirectory ? "S" : "N");
                System.out.println();
                Path newPath = Funcoes.zipSlipProtect(zipEntry, target);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    public static void post(HashMap<String, Object> p, MyCallback callback) {
        if (!p.containsKey("sistema")) {
            p.put("sistema", "sistema");
        }
        if (!p.containsKey("chave")) {
            p.put("chave", "d3hbfswp1y-6xupwbpnwt-nod6lwg1ak");
        }
        System.err.println(p);
        cURL curl = new cURL();
        curl.post("https://sic7.com.br/sic7_4/controller/controller.php", p, callback);
    }

    public static void iniciarComSistema(String acao) {
        if (Funcoes.isWindows()) {
            try {
                String caminho = Calebe.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                if (caminho.substring(0, 1).equals("/")) {
                    caminho = caminho.substring(1);
                }
                System.out.println("Caminho: " + caminho);
                caminho = caminho.replace("/", "\\");
                String javaw = System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaw";
                String cmd = acao.equals("delete") ? "reg delete HKCU\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run\\ /v Calebe /f" : "reg add HKCU\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run /v Calebe /t REG_SZ /d \"" + javaw + " -jar \\\"" + caminho + "\\\"\" /f";
                System.out.println("Iniciar com Windows: " + cmd);
                Funcoes.command(cmd);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Funcoes.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static String getValor(HashMap<String, Object> dados, String key, String _default) {
        try {
            return dados.get(key).toString();
        }
        catch (Exception e) {
            return _default;
        }
    }

    static String getValor(HashMap<String, Object> dados, String key) {
        return Funcoes.getValor(dados, key, "");
    }

    public static String getNow() {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date date = new Date();
        return format.format(date);
    }

    static String uniqueName() {
        SimpleDateFormat format = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
        Date date = new Date();
        return format.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURL(String surl, String pathname) {
        try {
            int len;
            URL url = new URL(surl);
            InputStream in = url.openStream();
            File file = new File(pathname);
            FileOutputStream os = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                for (int i = 0; i < len; ++i) {
                    os.write(buf[i]);
                }
            }
            os.flush();
            os.close();
            in.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    static int parseInt(String valor) {
        try {
            return Integer.parseInt(valor);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String getArquivoTempo(String arquivo, int tempo) {
        String ret = "-1";
        try {
            for (int i = 0; i < tempo && ((ret = Funcoes.file_get_contents(arquivo)).equals("-1") || ret.equals("-2") || ret.equals("-3")); ++i) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            ret = "-3";
        }
        return ret;
    }

    static boolean parseBool(String valor) {
        if (valor == null) {
            return false;
        }
        return valor.equals("true") || valor.equals("TRUE") || valor.equals("1");
    }

    static void emit(HashMap hashMap) {
        JSONObject json = new JSONObject();
        Iterator keys = hashMap.keySet().iterator();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)hashMap.get(key);
                System.err.println(key + ":" + value);
                json.put(key, value);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Comunicador.class.getName()).log(Level.SEVERE, null, ex);
        }
        Comunicador.socket.emit("dados", json);
    }

    public static String base64encode(String string) {
        return Base64.getEncoder().encodeToString(string.getBytes());
    }

    public static String base64decode(String encodedHello) {
        byte[] encodedHelloBytes = Base64.getDecoder().decode(encodedHello);
        String helloAgain = new String(encodedHelloBytes, StandardCharsets.UTF_8);
        return helloAgain;
    }

    public static void limparSpoolImpressao() {
        Principal.setNotificacao("Parando fila de impress\u00e3o...");
        String cmd = "net stop spooler";
        Funcoes.command(cmd);
        Principal.setNotificacao("Apagando os arquivos de impress\u00e3o...");
        cmd = "del %systemroot%\\System32\\spool\\printers\\* /Q";
        Funcoes.command(cmd);
        Principal.setNotificacao("Reiniciando servi\u00e7o de impress\u00e3o...");
        cmd = "net start spooler";
        Funcoes.command(cmd);
        Principal.setNotificacao("Impress\u00e3o liberada");
    }

    public static void setManterImpressaoErro(boolean s) {
        MANTER_IMPRESSAO_ERRO = s;
    }

    public static boolean getManterImpressaoErro() {
        return MANTER_IMPRESSAO_ERRO;
    }
}

