/*
 * Decompiled with CFR 0.152.
 */
package calebe;

import calebe.Principal;
import calebe.model.Funcoes;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPrintPage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class Impressora {
    private static PrintService impressora;

    public static List<String> getImpressoras() {
        try {
            PrintService[] ps;
            ArrayList<String> listaImpressoras = new ArrayList<String>();
            DocFlavor.SERVICE_FORMATTED df = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            for (PrintService p : ps = PrintServiceLookup.lookupPrintServices(df, null)) {
                listaImpressoras.add(p.getName());
            }
            return listaImpressoras;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean detectaImpressoras(String impressoraSelecionada) {
        try {
            PrintService[] ps;
            DocFlavor.SERVICE_FORMATTED df = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            for (PrintService p : ps = PrintServiceLookup.lookupPrintServices(df, null)) {
                if (p.getName() == null || !p.getName().contains(impressoraSelecionada)) continue;
                impressora = p;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void printPdf(String nomeImpressora, String pathname, boolean delete) {
        this.printPdf(nomeImpressora, pathname, delete, "P");
    }

    public void printPdf(String nomeImpressora, String pathname, boolean delete, String orientation) {
        this.printPdf(nomeImpressora, pathname, delete, orientation, 0, 0);
    }

    public void printPdf(String nomeImpressora, String pathname, boolean delete, String orientation, int width, int height) {
        File f = null;
        RandomAccessFile fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            ByteBuffer bb = null;
            f = new File(pathname);
            if (!this.detectaImpressoras(nomeImpressora)) {
                String msg = "Impressora " + nomeImpressora + " N\u00c3O encontrada";
                List<String> impressoras = Impressora.getImpressoras();
                msg = msg + "\nImpressoras dispon\u00edveis:";
                if (impressoras == null) {
                    msg = msg + "\nNenhuma impressora encontrada (NULL)";
                } else {
                    for (int i = 0; i < impressoras.size(); ++i) {
                        msg = msg + "\n" + impressoras.get(i);
                    }
                }
                Principal.setStatus(msg);
                f.delete();
                return;
            }
            Principal.setStatus("Enviando PDF para  " + nomeImpressora);
            fis = new RandomAccessFile(f, "rw");
            fc = fis.getChannel();
            bb = ByteBuffer.allocate((int)((FileChannel)fc).size());
            ((FileChannel)fc).read(bb);
            PDFFile pdfFile = new PDFFile(bb);
            PDFPrintPage pages = new PDFPrintPage(pdfFile);
            PrinterJob pjob = PrinterJob.getPrinterJob();
            pjob.setPrintService(impressora);
            PageFormat pf = PrinterJob.getPrinterJob().defaultPage();
            Paper paper = new Paper();
            if (width != 0) {
                paper.setSize(width, height);
                paper.setImageableArea(0.0, 0.0, width, height);
            }
            if (orientation.equals("L") || orientation.equals("l")) {
                pf.setOrientation(0);
                paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
            } else {
                pf.setOrientation(1);
                paper.setImageableArea(0.0, 0.0, paper.getWidth() * 2.0, paper.getHeight());
            }
            pf.setPaper(paper);
            pjob.setJobName(f.getName());
            Book book = new Book();
            book.append((Printable)pages, pf, pdfFile.getNumPages());
            pjob.setPageable(book);
            pjob.print();
            Principal.setStatus("Documento impresso em " + nomeImpressora);
            try {
                fc.close();
                fis.close();
                if (delete) {
                    f.delete();
                }
            }
            catch (Exception e) {
                Principal.setStatus("Erro ao excluir o arquivo1: " + e.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Principal.setStatus("Erro printPdf: " + e.getMessage());
            try {
                fc.close();
                fis.close();
                if (delete && !Funcoes.getManterImpressaoErro()) {
                    f.delete();
                }
            }
            catch (Exception ex) {
                Principal.setStatus("Erro ao excluir o arquivo2: " + ex.getMessage());
            }
        }
    }
}

